% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/erviss_variants.R
\name{plot_erviss_variants}
\alias{plot_erviss_variants}
\title{Plot ERVISS variants data}
\usage{
plot_erviss_variants(data, date_breaks = "1 month", date_format = "\%b \%Y")
}
\arguments{
\item{data}{A data.table or data.frame containing variant data, typically output from
\code{\link{get_erviss_variants}}. Must contain columns: date, value,
variant, countryname.}

\item{date_breaks}{A string specifying the date breaks for the x-axis
(e.g., "1 month", "2 weeks")}

\item{date_format}{A string specifying the date format for x-axis labels
(e.g., \code{"\%b \%Y"} for "Jan 2024")}
}
\value{
A ggplot2 object
}
\description{
Creates a ggplot2 visualization of variant data, with facets by country
and colored by variant. The y-axis shows percentage of all variants.
}
\examples{
\donttest{
data <- get_erviss_variants(
  date_min = as.Date("2024-06-01"),
  date_max = as.Date("2024-12-31"),
  variant = c("XFG", "LP.8.1")
)
plot_erviss_variants(data, date_breaks = "1 month")
}
}
