% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{aquacomm_fgps}
\alias{aquacomm_fgps}
\title{Macroinvertebrate aquatic community.}
\format{
A data frame with five variables:
}
\usage{
aquacomm_fgps
}
\description{
Dataset collected in an ecotoxicological study about the effects of insecticide (chlorpyrifos) use on a macroinvertebrate aquatic community (van den Brink et a. 1996, Wijngaarden_effects_1996). The community is composed of 128 species, classified into 5 functional groups: herbivores, detri-herbivores, carnivores, omnivores, and detrivores.
}
\section{Fields}{

\describe{
\item{\code{time}}{sequential week number relative to the application of insecticide}

\item{\code{treat}}{concentration of insecticide}

\item{\code{repli}}{number of replicate}

\item{\code{herb}}{abundance of herbivores}

\item{\code{detr_herb}}{abundance of detri-herbivores}

\item{\code{carn}}{abundance of carnivores}

\item{\code{omni}}{abundance of omnivores}

\item{\code{detr}}{abundance of detrivores}
}}

\references{
van den Brink, P. J., Van Wijngaarden, R. P. A., Lucassen, W. G. H., Brock, T. C. M., & Leeuwangh, P. (1996). Environmental Toxicology and Chemistry, 15(7), 1143–1153. \doi{10.1002/etc.5620150719}

Wijngaarden, R. P. A. van, Brink, P. J. van den, Crum, S. J. H., Brock, T. C. M., Leeuwangh, P., & Voshaar, O. J. H. (1996). Effects of the insecticide dursban® 4E (active ingredient chlorpyrifos) in outdoor experimental ditches: I. Comparison of short-term toxicity between the laboratory and the field. Environmental Toxicology and Chemistry, 15(7), 1133–1142. \doi{10.1002/etc.5620150718}
}
\keyword{datasets}
