% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/venn.R
\name{venn}
\alias{venn}
\alias{venn.default}
\alias{venn.table}
\alias{venn.data.frame}
\alias{venn.matrix}
\alias{venn.list}
\title{Venn diagrams}
\usage{
venn(combinations, ...)

\method{venn}{default}(
  combinations,
  input = c("disjoint", "union"),
  names = letters[length(combinations)],
  ...
)

\method{venn}{table}(combinations, ...)

\method{venn}{data.frame}(
  combinations,
  weights = NULL,
  by = NULL,
  sep = "_",
  factor_names = TRUE,
  ...
)

\method{venn}{matrix}(combinations, ...)

\method{venn}{list}(combinations, ...)
}
\arguments{
\item{combinations}{set relationships as a named numeric vector, matrix, or
data.frame (see \strong{methods (by class)})}

\item{...}{arguments passed down to other methods}

\item{input}{type of input: disjoint identities
(\code{'disjoint'}) or unions (\code{'union'}).}

\item{names}{a character vector for the names of each set of the same
length as 'combinations'. Must not be \code{NULL} if \code{combinations} is a
one-length numeric.}

\item{weights}{a numeric vector of weights of the same length as
the number of rows in \code{combinations}.}

\item{by}{a factor or character matrix to be used in \code{\link[base:by]{base::by()}} to
split the data.frame or matrix of set combinations}

\item{sep}{a character to use to separate the dummy-coded factors
if there are factor or character vectors in 'combinations'.}

\item{factor_names}{whether to include factor names when
constructing dummy codes}
}
\value{
Returns an object of class \verb{'venn', 'euler'} with items
\item{ellipses}{a matrix of \code{h} and \code{k} (x and y-coordinates for the
centers of the shapes), semiaxes \code{a} and \code{b}, and rotation angle \code{phi}}
\item{original.values}{set relationships in the input}
\item{fitted.values}{set relationships in the solution}
}
\description{
This function fits Venn diagrams using an interface that is
almost identical to \code{\link[=euler]{euler()}}. Strictly speaking,
Venn diagrams are Euler diagrams where every intersection is visible,
regardless of whether or not it is zero. In almost every incarnation of
Venn diagrams, however, the areas in the diagram are also
\emph{non-proportional} to the input; this is also the case here.
}
\section{Methods (by class)}{
\itemize{
\item \code{venn(default)}: a named numeric vector, with
combinations separated by an ampersand, for instance \code{A&B = 10}.
Missing combinations are treated as being 0.

\item \code{venn(table)}: A table with \code{max(dim(x)) < 3}.

\item \code{venn(data.frame)}: a \code{data.frame} of logicals, binary integers, or
factors.

\item \code{venn(matrix)}: a matrix that can be converted to a data.frame of logicals
(as in the description above) via \code{\link[base:as.data.frame]{base::as.data.frame.matrix()}}.

\item \code{venn(list)}: a list of vectors, each vector giving the contents of
that set (with no duplicates). Vectors in the list do not need to be named.

}}
\examples{
# The trivial version
f1 <- venn(5, names = letters[1:5])
plot(f1)

# Using data (a numeric vector)
f2 <- venn(c(A = 1, "B&C" = 3, "A&D" = 0.3))

# The table method
venn(pain, factor_names = FALSE)

# Using grouping via the 'by' argument through the data.frame method
venn(fruits, by = list(sex, age))


# Using the matrix method
venn(organisms)

# Using weights
venn(organisms, weights = c(10, 20, 5, 4, 8, 9, 2))

# A venn diagram from a list of sample spaces (the list method)
venn(plants[c("erigenia", "solanum", "cynodon")])
}
\seealso{
\code{\link[=plot.venn]{plot.venn()}}, \code{\link[=print.venn]{print.venn()}}, \code{\link[=euler]{euler()}}
}
