% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evolution.R
\name{send_list}
\alias{send_list}
\title{Send a list message}
\usage{
send_list(
  client,
  number,
  title,
  description,
  button_text,
  sections,
  footer = "",
  delay = NULL,
  verbose = FALSE
)
}
\arguments{
\item{client}{An \code{\link[=evo_client]{evo_client()}} object.}

\item{number}{Character. Recipient number with country code
(e.g., \code{"5581999990000"} or \code{"+5581999990000"}).}

\item{title}{Character. List message title.}

\item{description}{Character. List message body text.}

\item{button_text}{Character. Text displayed on the list button
(e.g., \code{"View options"}).}

\item{sections}{A list of section objects. Each section is a named
list with \code{title} and \code{rows}, where \code{rows} is a list of named lists
each containing \code{title}, optional \code{description}, and optional \code{rowId}.}

\item{footer}{Character. Footer text (required by the API, defaults
to \code{""}).}

\item{delay}{Integer (ms). Optional presence delay before sending.
Simulates typing before the message is sent.}

\item{verbose}{Logical. If \code{TRUE}, logs request/response details with
\strong{cli}.}
}
\value{
A named list with the API response. The HTTP status code is
stored in \code{attr(result, "http_status")}.
}
\description{
Sends an interactive list message via Evolution API v2.
List messages display a menu of selectable options organised into
sections.
}
\note{
\strong{Baileys connector:} Interactive list messages are \strong{not supported}
on the Baileys (WhatsApp Web) connector and are likely to be
discontinued. This endpoint is fully supported only on the \strong{Cloud API}
connector. If you are on Baileys, consider using \code{\link[=send_poll]{send_poll()}} as an
alternative.
}
\examples{
\dontrun{
send_list(client, "5581999990000",
  title = "Our Menu",
  description = "Select from the options below:",
  button_text = "View options",
  footer = "Powered by R",
  sections = list(
    list(title = "Drinks", rows = list(
      list(title = "Coffee", description = "Hot coffee", rowId = "1"),
      list(title = "Tea",    description = "Green tea",  rowId = "2")
    )),
    list(title = "Food", rows = list(
      list(title = "Cake", description = "Chocolate cake", rowId = "3")
    ))
  ))
}
}
\seealso{
\code{\link[=send_poll]{send_poll()}}
}
