% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evolution.R
\name{send_reaction}
\alias{send_reaction}
\title{React to a message}
\usage{
send_reaction(client, key, reaction, verbose = FALSE)
}
\arguments{
\item{client}{An \code{\link[=evo_client]{evo_client()}} object.}

\item{key}{List with \code{remoteJid}, \code{fromMe}, and \code{id} identifying the
target message.}

\item{reaction}{Emoji string (e.g., \code{"\\U0001f44d"} for thumbs up).
Use an empty string \code{""} to remove a reaction.}

\item{verbose}{Logical. If \code{TRUE}, logs request/response details with
\strong{cli}.}
}
\value{
A named list with the API response. The HTTP status code is
stored in \code{attr(result, "http_status")}.
}
\description{
Sends an emoji reaction to an existing message.
}
\examples{
\dontrun{
send_reaction(client, key = list(
  remoteJid = "5581999990000@s.whatsapp.net",
  fromMe = TRUE,
  id = "BAE594145F4C59B4"
), reaction = "\U0001f44d")
}
}
