% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GLARMA.R
\name{glance.GLARMA}
\alias{glance.GLARMA}
\title{Glance a GLARMA model}
\format{
A data frame with 1 row, with columns:
\describe{
  \item{sigma2}{The unbiased variance of residuals. Calculated as `sum(residuals^2) / (num_observations - num_pararameters + 1)`}
  \item{log_lik}{The log-likelihood}
  \item{AIC}{Akaike information criterion}
}
}
\usage{
\method{glance}{GLARMA}(x, ...)
}
\arguments{
\item{x}{model or other R object to convert to single-row data frame}

\item{...}{other arguments passed to methods}
}
\value{
A one row tibble summarising the model's fit.
}
\description{
Construct a single row summary of the GLARMA model.
}
\examples{
tsibbledata::aus_production |>
  fabletools::model(manual_ing = GLARMA(Beer ~ pq(1,1))) |>
  dplyr::select(manual_ing) |>
  glance()
}
