% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastMatMR-package.R
\name{spam_to_fmm}
\alias{spam_to_fmm}
\title{Convert a spam Sparse Matrix to Matrix Market Format}
\usage{
spam_to_fmm(input, filename)
}
\arguments{
\item{input}{A spam sparse matrix to be converted.}

\item{filename}{The name of the output file where the Matrix Market formatted
data will be saved.}
}
\value{
A boolean indicating success or failure. Writes a MTX file to disk.
}
\description{
This function takes a spam sparse matrix and converts it into a
Matrix Market file.
}
\examples{
\dontshow{if (requireNamespace("spam", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
sp <- spam::spam(c(1, 0, 0, 2), nrow = 2)
spam_to_fmm(sp, tempfile(fileext = ".mtx"))
\dontshow{\}) # examplesIf}
}
