% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_methods.R
\name{plot.vectorfield}
\alias{plot.vectorfield}
\title{Plot a 2D vector field}
\usage{
\method{plot}{vectorfield}(
  x,
  arrow = grid::arrow(length = grid::unit(0.1, "cm")),
  show_estimated_vector = TRUE,
  estimated_vector_enlarge = 1,
  estimated_vector_options = list(),
  show_point = TRUE,
  point_options = list(size = 0.5),
  show_original_vector = FALSE,
  original_vector_enlarge = 1,
  original_vector_options = list(),
  show_used_vector = FALSE,
  used_vector_options = list(color = "red"),
  show_v_norm = FALSE,
  v_norm_options = list(),
  ...
)
}
\arguments{
\item{x}{A \code{vectorfield} object estimated by \code{\link[=fit_2d_vf]{fit_2d_vf()}}.}

\item{arrow}{The description of the arrow heads of the vectors on the plot (representing the vector field). Generated by \code{\link[grid:arrow]{grid::arrow()}}. Also see the \code{arrow} parameter of \code{\link[ggplot2:geom_segment]{ggplot2::geom_segment()}}.}

\item{show_estimated_vector}{Show the vectors from the estimated model? \code{TRUE} by default.}

\item{estimated_vector_enlarge}{A number. How many times should the vectors (representing the estimated vector field) be enlarged on the plot? This can be useful when the estimated vector field is too strong or too weak.}

\item{estimated_vector_options}{A list passing other customized parameters to \code{\link[ggplot2:geom_segment]{ggplot2::geom_segment()}} to control the vectors representing the estimated vector field.}

\item{show_point}{Show the original data points? \code{TRUE} by default.}

\item{point_options}{A list passing other customized parameters to \code{\link[ggplot2:geom_point]{ggplot2::geom_point()}} to control the points representing the original data point.}

\item{show_original_vector}{Show the original vectors (i.e., the vectors between data points)? \code{FALSE} by default.}

\item{original_vector_enlarge}{A number. How many times should the original vectors be enlarged on the plot?}

\item{original_vector_options}{A list passing other customized parameters to \code{\link[ggplot2:geom_segment]{ggplot2::geom_segment()}} to control the vectors representing the original data.}

\item{show_used_vector}{Only for vector fields estimated by the "VFC" method. Should the vectors from the original data that are considered inliers be specially marked? \code{FALSE} by default.}

\item{used_vector_options}{Only for vector fields estimated by the "VFC" method. A list passing other customized parameters to \code{\link[ggplot2:geom_segment]{ggplot2::geom_segment()}} to control the vectors representing the inliers. Red by default.}

\item{show_v_norm}{Show the norm of the estimated vectors (the strength of the vector field)? \code{FALSE} by default.}

\item{v_norm_options}{A list passing other customized parameters to \code{\link[ggplot2:geom_tile]{ggplot2::geom_raster()}} to control the layer representing the norm of the estimated vectors.}

\item{...}{Not in use.}
}
\value{
A \code{ggplot2} plot.
}
\description{
Plot a 2D vector field estimated by \code{\link[=fit_2d_vf]{fit_2d_vf()}}. Powered by \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}.
}
