% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_importance_SL.R
\name{extract_importance_SL}
\alias{extract_importance_SL}
\title{Extract extrinsic importance from a Super Learner object}
\usage{
extract_importance_SL(fit, feature_names, import_type = "all", ...)
}
\arguments{
\item{fit}{the fitted Super Learner ensemble}

\item{feature_names}{the names of the features}

\item{import_type}{the level of granularity for importance: \code{"all"} is the
importance based on the weighted average of ranks across algorithmrithms
(weights are SL coefs); \code{"best"} is the importance based on the algorithmrithm
with highest weight. Defaults to \code{"all"}.}

\item{...}{other arguments to pass to individual-algorithm extractors.}
}
\value{
a tibble, with columns \code{feature} (the feature) and
\code{rank} (the weighted feature importance rank, with 1 indicating the
most important feature).
}
\description{
Extract the individual-algorithm extrinsic importance from each fitted
algorithm within the Super Learner; compute the average weighted rank of the
importance scores, with weights specified by each algorithm's weight in the
Super Learner.
}
\examples{
data("biomarkers")
# subset to complete cases for illustration
cc <- complete.cases(biomarkers)
dat_cc <- biomarkers[cc, ]
# use only the mucinous outcome, not the high-malignancy outcome
y <- dat_cc$mucinous
x <- dat_cc[, !(names(dat_cc) \%in\% c("mucinous", "high_malignancy"))]
feature_nms <- names(x)
# get the fit (using a simple library and 2 folds for illustration only)
set.seed(20231129)
library("SuperLearner")
fit <- SuperLearner::SuperLearner(Y = y, X = x, SL.library = c("SL.glm", "SL.mean"), 
                                  cvControl = list(V = 2))
# extract importance using all learners
importance <- extract_importance_SL(fit = fit, feature_names = feature_nms)
importance
# extract importance of best learner
best_importance <- extract_importance_SL(fit = fit, feature_names = feature_nms, 
                                         import_type = "best")
best_importance

}
