% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hr_flexsurvreg.R
\name{hr_flexsurvreg}
\alias{hr_flexsurvreg}
\title{Hazard ratio as a function of time from a parametric survival model}
\usage{
hr_flexsurvreg(
  x,
  newdata = NULL,
  t = NULL,
  start = 0,
  ci = TRUE,
  B = 1000,
  cl = 0.95,
  na.action = na.pass
)
}
\arguments{
\item{x}{Object returned by \code{\link{flexsurvreg}} or \code{\link{flexsurvspline}}.}

\item{newdata}{A data frame with two rows, each specifying a set of covariate values.
The hazard ratio is calculated as hazard(z2)/hazard(z1), where z1 is the first row 
of \code{newdata} and z2 is the second row.

\code{newdata} must be supplied unless the model \code{x} includes just one covariate.
With one covariate, a default is constructed, which defines the hazard ratio between
the second and first level of the factor (if the covariate is a factor), or between
a value of 1 and a value of 0 (if the covariate is numeric).}

\item{t}{Times to calculate fitted values for. By default, these are the
sorted unique observation (including censoring) times in the data - for
left-truncated datasets these are the "stop" times.}

\item{start}{Optional left-truncation time or times.  The returned
survival, hazard or cumulative hazard will be conditioned on survival up to
this time.   Predicted times returned with \code{"rmst"}, \code{"mean"}, \code{"median"} or \code{"quantile"}
will be times since time zero, not times since the \code{start} time.

A vector of the same length as \code{t} can be supplied to allow different
truncation times for each prediction time, though this doesn't make sense
in the usual case where this function is used to calculate a predicted
trajectory for a single individual.  This is why the default \code{start}
time was changed for version 0.4 of \pkg{flexsurv} - this was previously a
vector of the start times observed in the data.}

\item{ci}{Set to \code{FALSE} to omit confidence intervals.}

\item{B}{Number of simulations from the normal asymptotic distribution of
the estimates used to calculate confidence intervals or standard errors.
Decrease for greater
speed at the expense of accuracy, or set \code{B=0} to turn off calculation
of CIs and SEs.}

\item{cl}{Width of symmetric confidence intervals, relative to 1.}

\item{na.action}{Function determining what should be done with missing values in \code{newdata}.  If \code{na.pass} (the default) then summaries of \code{NA} are produced for missing covariate values.  If \code{na.omit}, then missing values are dropped, the behaviour of \code{summary.flexsurvreg} before \code{flexsurv} version 1.2.}
}
\value{
A data frame with estimate and confidence limits for the hazard ratio, and
one row for each of the times requested in \code{t}.
}
\description{
Hazard ratio as a function of time from a parametric survival model
}
