% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DoU-classify-grid-water.R
\name{DoU_classify_grid_water}
\alias{DoU_classify_grid_water}
\title{Create the DEGURBA grid cell classification of water cells}
\usage{
DoU_classify_grid_water(
  data,
  classification = NULL,
  water_land_threshold = 0.5,
  water_pop_threshold = 0,
  water_built_threshold = 0,
  value = 0,
  allow_overwrite = c(1)
)
}
\arguments{
\item{data}{path to the directory with the data, or named list with the data as returned by function \code{\link[=DoU_preprocess_grid]{DoU_preprocess_grid()}}}

\item{classification}{SpatRaster. A grid to which the classification of water cells will be added. The grid can already contain the classification or urban centres, urban clusters and rural grid cell, but this is not mandatory. Note that the grid will be adapted in-place.}

\item{water_land_threshold}{numeric. Maximum proportion of permanent land allowed in a water cell}

\item{water_pop_threshold}{numeric. Maximum population size allowed in a water cell}

\item{water_built_threshold}{numeric. Maximum built-up area allowed in a water cell}

\item{value}{integer. Value assigned to water cells in the resulting grid}

\item{allow_overwrite}{vector. Values in \code{classification} that can be overwritten by water cells. By default, the classification of rural cells (\code{1}) can be overwritten, but the classification of urban clusters (\code{2}) and urban centres (\code{3}) cannot.}
}
\value{
SpatRaster with the grid cell classification of water cells
}
\description{
The Degree of Urbanisation identifies water cells as cells with no built-up area, no population, and less than 50\% permanent land.

For more information about the Degree of Urbanisation methodology, see the \href{https://ec.europa.eu/eurostat/statistics-explained/index.php?title=Applying_the_degree_of_urbanisation_manual}{methodological manual}, \href{https://ghsl.jrc.ec.europa.eu/documents/GHSL_Data_Package_2022.pdf}{GHSL Data Package 2022} and \href{https://ghsl.jrc.ec.europa.eu/documents/GHSL_Data_Package_2023.pdf}{GHSL Data Package 2023}.

The arguments of the function allow to adapt the standard specifications in the Degree of Urbanisation in order to construct an alternative version of the grid classification.
}
\examples{
data_belgium <- DoU_load_grid_data_belgium()
classification <- DoU_classify_grid_urban_centres(data_belgium)
classification <- DoU_classify_grid_urban_clusters(data_belgium, classification = classification)
classification <- DoU_classify_grid_rural(data_belgium, classification = classification)
classification <- DoU_classify_grid_water(data_belgium, classification = classification)
DoU_plot_grid(classification)
}
