#' Create a `graphviz` specification from a function matrix
#'
#' Given a function matrix created by [foodweb_matrix()], convert it into a text specification
#' that can be passed to [DiagrammeR::grViz()].
#'
#' @param funmat A function matrix generated by [foodweb_matrix()].
#'
#' @return A text string.
#'
#' @seealso [graphviz.org/](https://graphviz.org/)
#'
#' @export
#'
#' @examples
#'
#' fm <- matrix(c(0, 1, 1, 1, 0, 1, 0, 1, 0), nrow = 3)
#' colnames(fm) <- rownames(fm) <- c("foo", "bar", "baz")
#' graphviz_spec_from_matrix(fm)
graphviz_spec_from_matrix <- function(funmat) {
  template <- "digraph \'foodweb' {{{graph_data}\n}}"
  graph_data <- character()
  for (caller_name in rownames(funmat)) {
    called_fns <- colnames(funmat)[funmat[caller_name, ] > 0]
    called_fns <- glue::glue("\"{called_fns}()\"")
    if (length(called_fns) > 0) {
      spec <- glue::glue("  \"{caller_name}()\" -> {{ {paste(called_fns, collapse = ', ')} }}")
    } else {
      spec <- glue::glue("  \"{caller_name}()\"")
    }
    graph_data <- paste(graph_data, spec, sep = "\n")
  }
  glue::glue(template)
}
