% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/play4inaRow.R
\name{play4inaRow}
\alias{play4inaRow}
\title{Play a game of Four in a Row}
\usage{
play4inaRow(playerOne, playerTwo, verbose = TRUE)
}
\arguments{
\item{playerOne}{A function that takes the current board as input and returns
the next move (1-7) for Player 1.}

\item{playerTwo}{Same for Player 2. Note that both functions see their pieces
as "X" and opponent's pieces as "O".}

\item{verbose}{Logical value indicating whether or not to print the final
board to the console (default is \code{TRUE})}
}
\value{
Returns \code{1} or \code{2} to indicate whether Player 1 or Player
  2 was the winner. Returns \code{0} in the case of a tie.
}
\description{
Play a game of Four in a Row
}
\details{
The game is played on a \eqn{6 \times 7} grid and players alternate placing
markers in one of the \eqn{7} columns. The piece will "fall" to the lowest
unoccupied space in that column. The game ends when one player wins by
getting four pieces in a row (horizontally, vertically, or diagonally).

Note that every player will see their markers as \code{X}s when it is their turn.
}
\examples{
play4inaRow(randomBot, randomBot)

}
