% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache_read.R
\name{cache_list}
\alias{cache_list}
\title{List all cached values}
\usage{
cache_list()
}
\value{
A data frame with columns:
\describe{
\item{name}{Cache key name}
\item{expire_at}{Expiration timestamp (NA if no expiration)}
\item{created_at}{When the cache was created}
\item{updated_at}{When the cache was last updated}
\item{last_read_at}{When the cache was last read}
\item{status}{Either "active" or "expired"}
}
Returns an empty data frame if no cache entries exist.
}
\description{
Returns a data frame of all cache entries with their names, expiration times,
and status (expired or active).
}
\examples{
\donttest{
if (FALSE) {
# List all cache entries
cache_list()

# Filter to see only expired caches
cache_list() |> dplyr::filter(status == "expired")
}
}

}
