% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/configure.R
\name{configure_global}
\alias{configure_global}
\title{Configure Global Framework Settings}
\usage{
configure_global(settings = NULL, validate = TRUE)
}
\arguments{
\item{settings}{List. Settings to update (partial updates supported)}

\item{validate}{Logical. Validate settings before saving (default: TRUE)}
}
\value{
Invisibly returns updated global configuration
}
\description{
Unified function for reading and writing global Framework settings to ~/.frameworkrc.json.
This function provides a single source of truth for global configuration,
used by both the CLI and GUI interfaces.
}
\details{
\subsection{Global Settings Structure}{
\itemize{
\item \code{author} - Author information (name, email, affiliation)
\item \code{defaults} - Project defaults
\itemize{
\item \code{project_type} - Default project type ("project", "presentation", "course")
\item \code{notebook_format} - Default notebook format ("quarto", "rmarkdown")
\item \code{ide} - IDE preference ("vscode", "rstudio", "both", "none")
\item \code{use_git} - Initialize git repositories by default
\item \code{use_renv} - Enable renv by default
\item \code{seed} - Default random seed
\item \code{seed_on_scaffold} - Set seed during scaffold()
\item \code{ai_support} - Enable AI assistant support
\item \code{ai_assistants} - List of AI assistants ("claude", "agents", etc.)
\item \code{ai_canonical_file} - Canonical AI instruction file
\item \code{packages} - Default package list
\item \code{directories} - Default directory structure
\item \code{git_hooks} - Git hook preferences
}
\item \code{projects} - Registered projects list
\item \code{active_project} - Currently active project path
}
}
}
\examples{
\donttest{
if (FALSE) {
# Update author information
configure_global(settings = list(
  author = list(
    name = "Jane Doe",
    email = "jane@example.com"
  )
))

# Update default project type
configure_global(settings = list(
  defaults = list(
    project_type = "presentation"
  )
))

# Get current settings (read-only)
current <- configure_global()
}
}

}
