% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/publish.R
\name{publish_list}
\alias{publish_list}
\title{List published files in S3}
\usage{
publish_list(prefix = NULL, connection = NULL, max = 1000L)
}
\arguments{
\item{prefix}{Character or NULL. Prefix to filter by. If NULL, lists all
files under the connection's configured prefix.}

\item{connection}{Character or NULL. S3 connection name, or NULL for default.}

\item{max}{Integer. Maximum number of files to list. Default 1000.}
}
\value{
Data frame with columns: key, size, last_modified.
}
\description{
Lists files in an S3 bucket/prefix.
}
\examples{
\donttest{
if (FALSE) {
# List all published files
publish_list()

# List files under a prefix
publish_list("reports/")

# List from specific connection
publish_list(connection = "s3_backup")
}
}
}
