% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geo.R
\name{geo_object_check}
\alias{geo_object_check}
\title{Check that spatial objects are valid \code{sf} layers with expected geometry type}
\usage{
geo_object_check(
  ...,
  check_class = TRUE,
  check_valid = TRUE,
  check_empty = TRUE,
  allowed_geom_classes = "POLYGON"
)
}
\arguments{
\item{...}{One or several spatial objects to test.}

\item{check_class}{Logical. Whether to check that each object inherits from
class \code{sf}. Default is \code{TRUE}.}

\item{check_valid}{Logical. Whether to check that geometries are valid.
Default is \code{TRUE}.}

\item{check_empty}{Logical. Whether to check that geometries are not empty.
Default is \code{TRUE}.}

\item{allowed_geom_classes}{Character vector of allowed geometry types
(e.g., \code{"POLYGON"}, \code{"LINE"}, \code{"POINT"}). If \code{NULL}, the geometry type
is not checked. Default is \code{"POLYGON"}.}
}
\value{
Invisibly returns \code{NULL}. Throws an error if any object fails validation.
}
\description{
This internal helper verifies that all provided objects:
\itemize{
\item are of class \code{sf} (optional, controlled by \code{check_class});
\item contain valid geometries (\code{sf::st_is_valid()});
\item contain no empty geometries (\code{!sf::st_is_empty()});
\item have a geometry type among the allowed ones (if specified).
}
}
\details{
The function raises an informative error message if any condition fails.
It is intended for internal validation of \code{sf} inputs before performing
geometric operations or API queries.

Geometry type validation is performed via \code{\link[=geo_object_type]{geo_object_type()}}, which ensures
type consistency across geometries.
}
\seealso{
\code{\link[=geo_object_type]{geo_object_type()}}
}
\keyword{internal}
