% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file_string.R
\name{file_string}
\alias{file_string}
\title{Substitute All Blanks and Punctuations in a String with an Underscore}
\usage{
file_string(x, replacement = c("_", "-"))
}
\arguments{
\item{x}{A string.}

\item{replacement}{The replacement character.}
}
\value{
A string.
}
\description{
Need to store stuff on disk. 
Replacement may also be a minus sign instead of underscore.
}
\examples{
file_string("foo:bar$ this, indeed(!) is # a number 7")
file_string("foo:bar$ this, indeed(!) is # a number 7", replacement = "-")
}
\seealso{
Other file utilities: 
\code{\link{clipboard_path}()},
\code{\link{delete_trailing_blank_lines}()},
\code{\link{delete_trailing_whitespace}()},
\code{\link{develop_test}()},
\code{\link{file_copy}()},
\code{\link{file_modified_last}()},
\code{\link{file_save}()},
\code{\link{find_files}()},
\code{\link{get_lines_between_tags}()},
\code{\link{get_mtime}()},
\code{\link{get_unique_string}()},
\code{\link{grep_file}()},
\code{\link{is_files_current}()},
\code{\link{is_path}()},
\code{\link{paths}},
\code{\link{runsed}()},
\code{\link{search_files}()},
\code{\link{split_code_file}()},
\code{\link{touch}()}

Other vector functions: 
\code{\link{char2factor}()},
\code{\link{escape_non_ascii}()},
\code{\link{powers_of_ten}}
}
\concept{file utilities}
\concept{vector functions}
