% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S4_utilities.R
\name{add_motif}
\alias{add_motif}
\title{Add Motif to Base Curve}
\usage{
add_motif(
  base_curve,
  mot_pattern,
  mot_len,
  dist_knots,
  mot_order,
  mot_weights,
  noise_str,
  only_der,
  coeff_min_shift,
  coeff_max_shift
)
}
\arguments{
\item{base_curve}{A list representing the base curve structure with coefficients and basis.}

\item{mot_pattern}{A data frame containing information about the motif patterns to add.}

\item{mot_len}{A matrix specifying the lengths of the motifs.}

\item{dist_knots}{A numeric value indicating the distance between knots for the motifs.}

\item{mot_order}{An integer specifying the order of the B-spline for the motifs.}

\item{mot_weights}{A list of numeric vectors containing weights for each motif.}

\item{noise_str}{A list of structures defining the noise to be added to motifs.}

\item{only_der}{A logical value indicating whether to add only derivatives.}

\item{coeff_min_shift}{A numeric value for the minimum shift to apply to coefficients.}

\item{coeff_max_shift}{A numeric value for the maximum shift to apply to coefficients.}
}
\value{
A list containing the updated base curve, background information, motifs with and without noise, and SNR data.
}
\description{
This function adds specified motifs to a base curve, adjusting coefficients and applying noise as needed. It also computes the 
signal-to-noise ratio (SNR) for the motifs.
}
\details{
Add Motif to Base Curve
}
