% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/g6.R
\name{g6-shiny}
\alias{g6-shiny}
\alias{g6Output}
\alias{g6_output}
\alias{renderG6}
\alias{render_g6}
\title{Shiny bindings for g6}
\usage{
g6Output(outputId, width = "100\%", height = "400px")

g6_output(outputId, width = "100\%", height = "400px")

renderG6(expr, env = parent.frame(), quoted = FALSE)

render_g6(expr, env = parent.frame(), quoted = FALSE)
}
\arguments{
\item{outputId}{output variable to read from}

\item{width, height}{Must be a valid CSS unit (like \code{'100\%'},
\code{'400px'}, \code{'auto'}) or a number, which will be coerced to a
string and have \code{'px'} appended.}

\item{expr}{An expression that generates a g6}

\item{env}{The environment in which to evaluate \code{expr}.}

\item{quoted}{Is \code{expr} a quoted expression (with \code{quote()})? This
is useful if you want to save an expression in a variable.}
}
\value{
\code{g6Output} and \code{g6_output}
return a Shiny output function that can be used in the UI part of a Shiny app.
\code{renderG6} and \code{render_g6} return a
Shiny render function that can be used in the server part of a Shiny app to
render a \code{g6} element.
}
\description{
Output and render functions for using g6 within Shiny
applications and interactive Rmd documents.
}
