% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gb-get-world.R
\encoding{UTF-8}
\name{gb_get_world}
\alias{gb_get_world}
\alias{gb_get_cgaz}
\title{Get global composites data (CGAZ) from geoBoundaries}
\source{
geoBoundaries API Service \url{https://www.geoboundaries.org/api.html}.
}
\usage{
gb_get_world(
  country = "all",
  adm_lvl = "adm0",
  quiet = TRUE,
  overwrite = FALSE,
  cache_dir = NULL
)
}
\arguments{
\item{country}{A character vector of country codes. It can be either
\code{"all"} (that would return the data for all countries), a vector of country
names or ISO3 country codes. See also \code{\link[countrycode:countrycode]{countrycode::countrycode()}}.}

\item{adm_lvl}{Type of boundary. Accepted values are administrative
levels 0, 1, and 2 (\code{"adm0"} is the country boundary,
\code{"adm1"} is the first level of sub-national boundaries, \code{"adm2"} is the
second level, and so on). Upper-case versions (\code{"ADM1"}) and the number of
the level (\verb{0, 1, 2}) are also accepted.}

\item{quiet}{logical. If \code{TRUE} suppresses informational messages.}

\item{overwrite}{logical. When set to \code{TRUE} it will force a fresh
download of the source \code{.zip} file.}

\item{cache_dir}{A path to a cache directory. If not set (the default
\code{NULL}), the data will be stored in the default cache directory (see
\code{\link[=gb_set_cache_dir]{gb_set_cache_dir()}}). If no cache directory has been set, files will be
stored in the temporary directory (see \code{base::tempdir()}). See caching
strategies in \code{\link[=gb_set_cache_dir]{gb_set_cache_dir()}}.}
}
\value{
A \code{\link[sf:sf]{sf}} object.
}
\description{
\href{https://www.geoboundaries.org/index.html#usage}{Attribution} is required
for all uses of this dataset.

This function returns a global composite of the required administrative
level, clipped to international boundaries, with gaps filled between
borders.
}
\details{
Comprehensive Global Administrative Zones (CGAZ) are a set of global
composites for administrative boundaries. There are two important
distinctions between our global product and individual country downloads.
\itemize{
\item Extensive simplification is performed to ensure that file sizes are
small enough to be used in most traditional desktop software.
\item Disputed areas are removed and replaced with polygons following US
Department of State definitions.
}
}
\examples{
\dontshow{if (identical(Sys.getenv("NOT_CRAN"), "true") || interactive()) withAutoprint(\{ # examplesIf}
# This download may take some time
\dontrun{
world <- gb_get_world()

library(ggplot2)

ggplot(world) +
  geom_sf() +
  coord_sf(expand = FALSE) +
  labs(caption = "Source: www.geoboundaries.org")
}
\dontshow{\}) # examplesIf}
}
\references{
Runfola, D. et al. (2020) geoBoundaries: A global database of political
administrative boundaries. \emph{PLOS ONE} \emph{15}(4), 1-9.
\doi{10.1371/journal.pone.0231866}.
}
\seealso{
Other API functions: 
\code{\link{gb_get}()},
\code{\link{gb_get_adm}}
}
\concept{API functions}
