% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gb-cache.R
\encoding{UTF-8}
\name{gb_set_cache_dir}
\alias{gb_set_cache_dir}
\title{Set your \pkg{geobounds} cache directory}
\usage{
gb_set_cache_dir(cache_dir, overwrite = FALSE, install = FALSE, quiet = FALSE)
}
\arguments{
\item{cache_dir}{A path to a cache directory. If missing, the function
will store the cache files in a temporary directory (see
\code{\link[base:tempfile]{base::tempdir()}}).}

\item{overwrite}{Logical. If this is set to \code{TRUE}, it will overwrite an
existing \code{cache_dir}.}

\item{install}{Logical. If \code{TRUE}, will install the key in your local
machine for use in future sessions. Defaults to \code{FALSE}. If \code{cache_dir}
is \code{FALSE} this parameter is set to \code{FALSE} automatically.}

\item{quiet}{logical. If \code{TRUE} suppresses informational messages.}
}
\value{
An (\code{\link[=invisible]{invisible()}}) character with the path to your \code{cache_dir}.
}
\description{
This function stores your \code{cache_dir} path on your local machine and
loads it for future sessions. Type \code{gb_detect_cache_dir()} to find
your cache directory path.
}
\details{
By default, when no \code{cache_dir} is set the package uses a folder inside
\code{\link[base:tempfile]{base::tempdir()}} (so files are temporary and are removed when the \strong{R}
session ends). To persist a cache across \strong{R} sessions, use
\code{gb_set_cache_dir(path, install = TRUE)}, which writes the chosen path to a
small configuration file under \code{tools::R_user_dir("geobounds", "config")}.
}
\section{Caching strategies}{

\itemize{
\item For occasional use, rely on the default \code{\link[=tempdir]{tempdir()}}-based cache (no
install).
\item Modify the cache for a single session by setting
\code{gb_set_cache_dir(cache_dir = "a/path/here")}.
\item For reproducible workflows, install a persistent cache with
\code{gb_set_cache_dir(cache_dir = "a/path/here", install = TRUE)} that will be
kept across \strong{R} sessions.
\item For caching specific files, use the \code{cache_dir} argument in the
corresponding function. See \code{\link[=gb_get]{gb_get()}}.
}
}

\examples{

# Caution! This may modify your current state

\dontrun{
my_cache <- gb_detect_cache_dir()

# Set an example cache
ex <- file.path(tempdir(), "example", "cachenew")
gb_set_cache_dir(ex)

gb_detect_cache_dir()

# Restore initial cache
gb_set_cache_dir(my_cache)
identical(my_cache, gb_detect_cache_dir())
}

gb_detect_cache_dir()
}
\seealso{
\code{\link[tools:userdir]{tools::R_user_dir()}}

Other cache utilities: 
\code{\link{gb_clear_cache}()},
\code{\link{gb_detect_cache_dir}()}
}
\concept{cache utilities}
