% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geoflow_utils.R
\name{enrich_text_from_entity}
\alias{enrich_text_from_entity}
\title{enrich_text_from_entity}
\usage{
enrich_text_from_entity(str, entity)
}
\arguments{
\item{str}{a text to be enriched}

\item{entity}{an object of class \code{geoflow_entity}}
}
\description{
\code{enrich_text_from_entity} will attempt to enrich an entity text property
from other entity metadata, depending on text variables handled by a pattern in the form
%property%. 

- If the entity property is a text, only the name of the property name is required.

- If the entity property is a list, then 2 subcases can be distinguished:

If it is a named list (such as entity descriptions), the text variable will be compound by
the entity property name and the element_property name, in the form %property:element_property%

If it is a unnamed list (such as list of keywords, list of relations, etc), the text variable will handle
four elements: property (entity property name to look at), a key value pair to use for search
within the list, an element_property for which the value should be picked up to enrich the text.
The variable willbe in the form %property:keye:value:element_property%
}
\author{
Emmanuel Blondel, \email{emmanuel.blondel1@gmail.com}
}
