% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geocoords.R
\name{geocoords_parse}
\alias{geocoords_parse}
\title{Parse Geographic Coordinate Strings}
\usage{
geocoords_parse(x)
}
\arguments{
\item{x}{Character vector of coordinate strings to parse}
}
\value{
Data frame with columns:
\itemize{
\item \code{lat} - Latitude in degrees
\item \code{lon} - Longitude in degrees
\item \code{zone} - UTM/UPS zone number
\item \code{northp} - Logical, TRUE if in northern hemisphere
\item \code{easting} - UTM/UPS easting in meters
\item \code{northing} - UTM/UPS northing in meters
}
}
\description{
Parse coordinate strings in various formats (MGRS, UTM/UPS, DMS, decimal)
and return latitude/longitude.
}
\details{
Accepts coordinates in multiple formats:
\itemize{
\item MGRS: \code{"33TWN0500049000"}
\item UTM/UPS: \code{"33N 505000 4900000"}
\item DMS: \verb{"40d26'47\\"N 74d0'21\\"W"}
\item Decimal: \code{"40.446 -74.006"}
}
}
\examples{
# Parse MGRS
geocoords_parse("33TWN0500049000")

# Parse UTM
geocoords_parse("33N 505000 4900000")

# Parse DMS
geocoords_parse("40d26'47\"N 74d0'21\"W")

# Parse decimal
geocoords_parse("40.446 -74.006")

# Vectorized
geocoords_parse(c("33TWN0500049000", "40.446 -74.006"))

}
\seealso{
\code{\link[=mgrs_fwd]{mgrs_fwd()}}, \code{\link[=mgrs_rev]{mgrs_rev()}}, \code{\link[=utmups_fwd]{utmups_fwd()}}, \code{\link[=utmups_rev]{utmups_rev()}}, \code{\link[=dms_decode]{dms_decode()}}
}
