% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/swath.R
\name{swath_stats}
\alias{swath_stats}
\title{Summary Statistics on Swath Elevation Profile}
\usage{
swath_stats(x, profile.length = 1)
}
\arguments{
\item{x}{list. The return object of \code{\link[=swath_profile]{swath_profile()}}}

\item{profile.length}{numeric or \code{units} object. If \code{NULL} the fractional
distance is returned, i.e. 0 at start and 1 at the end of the profile.}
}
\value{
data.frame
}
\description{
Statistics of the elevation data across a swath profile.
}
\examples{
# Create a random raster
r <- terra::rast(ncol = 10, nrow = 10, xmin = -150, xmax = -80, ymin = 20, ymax = 60)
terra::values(r) <- runif(terra::ncell(r))

# Create a random profile
profile <- data.frame(lon = c(-140, -90), lat = c(55, 25)) |>
  sf::st_as_sf(coords = c("lon", "lat"), crs = "WGS84")
swath <- swath_profile(profile, r, k = 5, dist = 10)

swath_stats(swath, profile.length = profile_length(profile_line(profile)))
}
\seealso{
\code{\link[=swath_profile]{swath_profile()}}
}
