## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(echo = TRUE)
knitr::opts_chunk$set(warning = FALSE)
knitr::opts_chunk$set(message = FALSE)
knitr::opts_chunk$set(out.width = "100%")
knitr::opts_chunk$set(fig.align = "center")
library(knitr)
library(ggInterval)
library(RSDA)

## ----data-facedata------------------------------------------------------------
data(facedata)
facedata

## ----data-summary-------------------------------------------------------------
summary(facedata)

## ----classic2sym-species------------------------------------------------------
myIris <- classic2sym(iris, groupby = "Species")
myIris$intervalData

## ----classic2sym-kmeans-------------------------------------------------------
myIris_km <- classic2sym(iris, groupby = "kmeans", k = 5)
myIris_km$intervalData

## ----rsda2sym, eval = FALSE---------------------------------------------------
# mySym <- RSDA2sym(Cardiological)
# mySym$intervalData

## ----stat-summary-------------------------------------------------------------
summary(facedata)

## ----stat-cor-----------------------------------------------------------------
cor(facedata)

## ----stat-cov-----------------------------------------------------------------
cov(facedata)

## ----stat-scale---------------------------------------------------------------
facedata_scaled <- scale(facedata)
facedata_scaled

## ----indexplot, fig.width = 7, fig.height = 4---------------------------------
ggInterval_indexplot(facedata, aes(x = AD))

## ----indeximage-col, fig.width = 7, fig.height = 4----------------------------
ggInterval_indexImage(facedata, aes(AD),
                      column_condition = TRUE, full_strip = FALSE)

## ----indeximage-full, fig.width = 7, fig.height = 4---------------------------
ggInterval_indexImage(facedata, aes(AD),
                      column_condition = TRUE, full_strip = TRUE) +
  coord_flip()

## ----boxplot-single, fig.width = 7, fig.height = 4----------------------------
ggInterval_boxplot(facedata, aes(AD))

## ----boxplot-all, fig.width = 7, fig.height = 5-------------------------------
ggInterval_boxplot(facedata, plotAll = TRUE)

## ----hist-equal, fig.width = 7, fig.height = 4--------------------------------
ggInterval_hist(facedata, aes(x = AD), bins = 10,
                method = "equal-bin")$plot

## ----hist-unequal, fig.width = 7, fig.height = 4------------------------------
ggInterval_hist(facedata, aes(x = AD),
                method = "unequal-bin")$plot

## ----mmplot, fig.width = 7, fig.height = 4------------------------------------
ggInterval_MMplot(facedata, aes(AD))

## ----mmplot-all, fig.width = 7, fig.height = 5--------------------------------
ggInterval_MMplot(facedata, plotAll = TRUE)

## ----crplot, fig.width = 7, fig.height = 4------------------------------------
ggInterval_CRplot(facedata, aes(AD))

## ----crplot-all, fig.width = 7, fig.height = 5--------------------------------
ggInterval_CRplot(facedata, plotAll = TRUE)

## ----scatterplot, fig.width = 7, fig.height = 5-------------------------------
ggInterval_scatterplot(facedata, aes(x = AD, y = BC))

## ----hist2d, fig.width = 7, fig.height = 5------------------------------------
ggInterval_2Dhist(facedata, aes(x = AD, y = BC), xBins = 10, yBins = 10)

## ----hist2d-oils, fig.width = 7, fig.height = 5-------------------------------
data(oils)
ggInterval_2Dhist(oils, aes(x = GRA, y = FRE), xBins = 5, yBins = 5)

## ----scattermatrix, fig.width = 8, fig.height = 8-----------------------------
ggInterval_scatterMatrix(facedata[, 1:3])

## ----histmatrix, fig.width = 8, fig.height = 8--------------------------------
ggInterval_2DhistMatrix(oils, xBins = 5, yBins = 5)

## ----indeximage-heatmap, fig.width = 8, fig.height = 5------------------------
ggInterval_indexImage(facedata, plotAll = TRUE)

## ----radar-polygon, fig.width = 7, fig.height = 6-----------------------------
data(Environment)
ggInterval_radarplot(Environment[, 5:17],
                     plotPartial = 2,
                     showLegend = FALSE,
                     base_circle = TRUE,
                     base_lty = 2,
                     addText = FALSE) +
  labs(title = "Environment: radar plot (default)")

## ----radar-rect, fig.width = 7, fig.height = 6--------------------------------
ggInterval_radarplot(Environment[, 5:17],
                     plotPartial = 2,
                     type = "rect",
                     showLegend = FALSE,
                     base_circle = TRUE,
                     addText = FALSE) +
  labs(title = "Environment: radar plot (rect)")

## ----scatter3d, fig.width = 7, fig.height = 6---------------------------------
ggInterval_3Dscatterplot(facedata[1:5, ], aes(x = BC, y = EH, z = GH))

## ----pca, fig.width = 7, fig.height = 5---------------------------------------
pca_result <- ggInterval_PCA(facedata, plot = FALSE)
pca_result$ggplotPCA

## ----pca-poly, fig.width = 7, fig.height = 5----------------------------------
pca_poly <- ggInterval_PCA(facedata, poly = TRUE, plot = FALSE)
pca_poly$ggplotPCA

## ----pca-iris, fig.width = 7, fig.height = 5----------------------------------
myIris <- classic2sym(iris, groupby = "Species")
pca_iris <- ggInterval_PCA(myIris, plot = FALSE)
pca_iris$ggplotPCA

## ----ggplot2-theme, fig.width = 7, fig.height = 4-----------------------------
ggInterval_indexplot(facedata, aes(x = AD)) +
  theme_minimal() +
  labs(title = "Index plot of AD", x = "Observation", y = "AD")

## ----ggplot2-scale, fig.width = 7, fig.height = 4-----------------------------
p <- ggInterval_hist(facedata, aes(x = AD), bins = 10,
                     method = "equal-bin")$plot
p + scale_fill_manual(values = rainbow(10))

## ----ggplot2-ref, fig.width = 7, fig.height = 4-------------------------------
ggInterval_CRplot(facedata, aes(AD)) +
  geom_hline(yintercept = 5, linetype = "dashed", color = "red")

