% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggInterval_scatterplot.R
\name{ggInterval_scatterplot}
\alias{ggInterval_scatterplot}
\title{scatter plot for two continuous interval data}
\usage{
ggInterval_scatterplot(data = NULL,mapping = aes(NULL), ...)
}
\arguments{
\item{data}{A ggInterval object.It can also be either RSDA object or
classical data frame, which will be automatically convert to ggInterval
data.}

\item{mapping}{Set of aesthetic mappings created by aes() or aes_().
If specified and inherit. aes = TRUE (the default),
it is combined with the default mapping at the top level of
the plot. You must supply mapping if there is no plot mapping.}

\item{...}{Others in ggplot2.}
}
\value{
Return a ggplot2 object.
}
\description{
Visualize the twwo continuous variable distribution
by rectangle and each of its width and heigth represents a
interval of the data.
}
\examples{
\donttest{
a<-rnorm(1000,0,5)
b<-runif(1000,-20,-10)
d<-as.data.frame(cbind(norm=a,unif=b))
ggInterval_scatterplot(d,aes(a,b))


ggInterval_scatterplot(mtcars[,c("mpg","wt","qsec")],
    aes(x=mpg,y=wt,
    col="red",lty=2,fill="blue",alpha=0.3))


myIris <- classic2sym(iris,groupby = "Species")$intervalData
p<-ggInterval_scatterplot(myIris,aes(myIris$Petal.Length,myIris$Petal.Width))
p
p+scale_fill_manual(labels=rownames(myIris),
                   values=c("red","blue","green"),
                   name="Group")


mydata <- ggInterval::facedata
p<-ggInterval_scatterplot(mydata[1:10,],aes(AD,BC,alpha=0.2))
p+scale_fill_manual(labels=rownames(mydata)[1:10],
                   values=rainbow(10),
                   name="Group")
}
}
