% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_cloud.R
\name{geom_cloud}
\alias{geom_cloud}
\title{geom_cloud}
\usage{
geom_cloud(
  mapping = NULL,
  data = NULL,
  ...,
  na.rm = TRUE,
  steps = 7,
  se_mult = 1,
  max_alpha = 1,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}'s \code{params} argument. These
arguments broadly fall into one of 4 categories below. Notably, further
arguments to the \code{position} argument, or aesthetics that are required
can \emph{not} be passed through \code{...}. Unknown arguments that are not part
of the 4 categories below are ignored.
\itemize{
\item Static aesthetics that are not mapped to a scale, but are at a fixed
value and apply to the layer as a whole. For example, \code{colour = "red"}
or \code{linewidth = 3}. The geom's documentation has an \strong{Aesthetics}
section that lists the available options. The 'required' aesthetics
cannot be passed on to the \code{params}. Please note that while passing
unmapped aesthetics as vectors is technically possible, the order and
required length is not guaranteed to be parallel to the input data.
\item When constructing a layer using
a \verb{stat_*()} function, the \code{...} argument can be used to pass on
parameters to the \code{geom} part of the layer. An example of this is
\code{stat_density(geom = "area", outline.type = "both")}. The geom's
documentation lists which parameters it can accept.
\item Inversely, when constructing a layer using a
\verb{geom_*()} function, the \code{...} argument can be used to pass on parameters
to the \code{stat} part of the layer. An example of this is
\code{geom_area(stat = "density", adjust = 0.5)}. The stat's documentation
lists which parameters it can accept.
\item The \code{key_glyph} argument of \code{\link[ggplot2:layer]{layer()}} may also be passed on through
\code{...}. This can be one of the functions described as
\link[ggplot2:draw_key]{key glyphs}, to change the display of the layer in the legend.
}}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{steps}{The integer number of steps, or equivalently, the number of
overlapping ribbons. A larger number makes a smoother cloud
at the possible expense of rendering time. Values larger than
around 20 are typically not necessary.}

\item{se_mult}{The \sQuote{multiplier} of standard errors of the given
\code{ymin} and \code{ymax}. If these are at one standard error,
then let \code{se_mult} take the default value of 1.}

\item{max_alpha}{The maximum alpha at the maximum density. The cloud
will have alpha no greater than this value.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}
}
\description{
Draw a normal uncertainty cloud as a ribbon

Draws overlapping ribbons of the same identity to create 
a cloud of (Gaussian) uncertainty. Similar to an errorbar geom in
use, but visually less distracting (sometimes).
}
\details{
Assumes that \code{ymin} and \code{ymax} are plotted at a 
fixed number of standard errors away from \code{y}, then computes
a Gaussian density with that standard deviation, plotting a cloud
(based on \code{geom_ribbon}) with alpha proportional to the density.
This appears as a vertical \sQuote{cloud} of uncertainty. In use,
this geom should be comparable to \code{geom_errorbar}.

A sample output from \code{geom_cloud}:

\if{html}{
\figure{geomcloud-1.png}{options: style="width: 100\%;" alt="Figure: geomcloud-1.png"}
}
\if{latex}{
\figure{geomcloud-1.png}{options: width=10cm}
}
}
\note{
This is a thin wrapper on the \code{geom_ribbon} geom.
}
\section{Aesthetics}{

\code{geom_cloud} understands the following aesthetics (required aesthetics
are in bold):
\itemize{
  \item \strong{\code{x}}
  \item \strong{\code{y}}
  \item \strong{\code{ymin}}
  \item \strong{\code{ymax}}
  \item \code{fill}
}
Only one of \code{ymin} and \code{ymax} is strictly required.
}

\examples{
set.seed(2134)
nobs <- 200
mydat <- data.frame(grp=sample(c(0,1),nobs,replace=TRUE),
  colfac=sample(letters[1:2],nobs,replace=TRUE),
  rowfac=sample(letters[10 + (1:3)],nobs,replace=TRUE)) 
mydat$x <- seq(0,1,length.out=nobs) + 0.33 * mydat$grp
mydat$y <- 0.25 * rnorm(nobs) + 2 * mydat$grp
mydat$grp <- factor(mydat$grp)
mydat$se  <- sqrt(mydat$x)

ggplot(mydat,aes(x=x,y=y,ymin=y-se,ymax=y+se,color=grp)) +
facet_grid(rowfac ~ colfac) + 
geom_line() + 
geom_errorbar() + 
labs(title='uncertainty by errorbar')

ggplot(mydat,aes(x=x,y=y,ymin=y-se,ymax=y+se,fill=grp)) +
facet_grid(rowfac ~ colfac) + 
geom_line() + 
geom_cloud(steps=15,max_alpha=0.85) +
labs(title='uncertainty by cloudr')
}
\seealso{
\code{\link[ggplot2]{geom_ribbon}}: The underlying geom
}
\author{
Steven E. Pav \email{shabbychef@gmail.com}
}
\keyword{plotting}
