% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-flow.r
\name{geom_flow}
\alias{geom_flow}
\alias{positions_to_flow}
\title{Flows between lodes or strata}
\usage{
geom_flow(
  mapping = NULL,
  data = NULL,
  stat = "flow",
  position = "identity",
  width = 1/3,
  knot.pos = 1/4,
  knot.prop = TRUE,
  curve_type = NULL,
  curve_range = NULL,
  segments = NULL,
  outline.type = "both",
  aes.flow = "forward",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  ...
)

positions_to_flow(
  x0,
  x1,
  ymin0,
  ymax0,
  ymin1,
  ymax1,
  kp0,
  kp1,
  knot.prop,
  curve_type,
  curve_range,
  segments
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{stat}{The statistical transformation to use on the data;
override the default.}

\item{position}{Position adjustment, either as a string naming the adjustment
(e.g. \code{"jitter"} to use \code{position_jitter}), or the result of a call to a
position adjustment function. Use the latter if you need to change the
settings of the adjustment.}

\item{width}{Numeric; the width of each stratum, as a proportion of the
distance between axes. Defaults to 1/3.}

\item{knot.pos}{The horizontal distance of x-spline knots from each stratum
(\code{width/2} from its axis), either (if \code{knot.prop = TRUE}, the default) as a
proportion of the length of the x-spline, i.e. of the gap between adjacent
strata, or (if \code{knot.prop = FALSE}) on the scale of the \code{x} direction.}

\item{knot.prop}{Logical; whether to interpret \code{knot.pos} as a proportion of
the length of each flow (the default), rather than on the \code{x} scale.}

\item{curve_type}{Character; the type of curve used to produce flows.
Defaults to \code{"xspline"} and can be alternatively set to one of \code{"linear"},
\code{"cubic"}, \code{"quintic"}, \code{"sine"}, \code{"arctangent"}, and \code{"sigmoid"}.
\code{"xspline"} produces approximation splines using 4 points per curve; the
alternatives produce interpolation splines between points along the graphs
of functions of the associated type. See the \strong{Curves} section.}

\item{curve_range}{For alternative \code{curve_type}s based on asymptotic
functions, the value along the asymptote at which to truncate the function
to obtain the shape that will be scaled to fit between strata. See the
\strong{Curves} section.}

\item{segments}{The number of segments to be used in drawing each alternative
curve (each curved boundary of each flow). If less than 3, will be silently
changed to 3.}

\item{outline.type}{Type of outline of each alluvium; one of \code{"both"},
\code{"lower"}, \code{"upper"}, and \code{"full"}.}

\item{aes.flow}{Character; how inter-lode flows assume aesthetics from lodes.
Options are "forward" and "backward".}

\item{na.rm}{Logical:
if \code{FALSE}, the default, \code{NA} lodes are not included;
if \code{TRUE}, \code{NA} lodes constitute a separate category,
plotted in grey (regardless of the color scheme).}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{...}{Additional arguments passed to \code{\link[ggplot2:layer]{ggplot2::layer()}}.}

\item{x0, x1, ymin0, ymax0, ymin1, ymax1, kp0, kp1}{Numeric corner and knot position
data for the ribbon of a single flow.}
}
\description{
\code{geom_flow} receives a dataset of the horizontal (\code{x}) and vertical (\code{y},
\code{ymin}, \code{ymax}) positions of the \strong{lodes} of an alluvial plot, the
intersections of the alluvia with the strata. It reconfigures these into
alluvial segments connecting pairs of corresponding lodes in adjacent strata
and plots filled x-splines between each such pair, using a provided knot
position parameter \code{knot.pos}, and filled rectangles at either end, using a
provided \code{width}.
}
\details{
The helper function \code{positions_to_flow()} takes the corner and knot positions
and curve parameters for a single flow as input and returns a data frame of
\code{x}, \code{y}, and \code{shape} used by \code{\link[grid:grid.xspline]{grid::xsplineGrob()}} to render the flow.
}
\section{Aesthetics}{

\code{geom_alluvium}, \code{geom_flow}, \code{geom_lode}, and \code{geom_stratum} understand the
following aesthetics (required aesthetics are in bold):
\itemize{
\item \strong{\code{x}}
\item \strong{\code{y}}
\item \strong{\code{ymin}}
\item \strong{\code{ymax}}
\item \code{alpha}
\item \code{colour}
\item \code{fill}
\item \code{linetype}
\item \code{size}
\item \code{group}
}

\code{group} is used internally; arguments are ignored.

Alluvium, flow, and lode geoms default to \code{alpha = 0.5}. Learn more about
setting these aesthetics in \code{vignette("ggplot2-specs", package = "ggplot2")}.
}

\section{Curves}{

By default, \code{geom_alluvium()} and \code{geom_flow()} render flows between lodes as
filled regions between parallel x-splines. These graphical elements,
generated using \code{\link[grid:grid.xspline]{grid::xsplineGrob()}}, are
parameterized by the relative location of the knot (\code{knot.pos}). They are
quick to render and clear to read, but users may prefer plots that use
differently-shaped ribbons.

A variety of such options are documented at, e.g., \href{https://easings.net/}{this easing functions cheat sheet} and \href{https://www.dataplusscience.com/Sigmoid.html}{this blog post by Jeffrey Shaffer}. Easing functions are
not (yet) used in ggalluvial, but several alternative curves are available.
Each is encoded as a continuous, increasing, bijective function from the unit
interval \eqn{[0,1]} to itself, and each is rescaled so that its endpoints
meet the corresponding lodes. They are rendered piecewise-linearly, by
default using \code{segments = 48}. Summon each curve type by passing one of the
following strings to \code{curve_type}:
\itemize{
\item \code{"linear"}:     \eqn{f(x)=x}, the unique degree-1 polynomial that takes
0 to 0 and 1 to 1
\item \code{"cubic"}:      \eqn{f(x)=3x^{2}-2x^{3}}{f(x)=3x^2-2x^3}, the unique
degree-3 polynomial that also is flat at both endpoints
\item \code{"quintic"}:    \eqn{f(x)=10x^{3}-15x^{4}+6x^{5}}{f(x)=10x^3-15x^4+6x^5},
the unique degree-5 polynomial that also has zero curvature
at both endpoints
\item \code{"sine"}:       the unique sinusoidal function that is flat at both
endpoints
\item \code{"arctangent"}: the inverse tangent function, scaled and re-centered to the
unit interval from the interval centered at zero with
radius \code{curve_range}
\item \code{"sigmoid"}:    the sigmoid function, scaled and re-centered to the unit
interval from the interval centered at zero with radius
\code{curve_range}
}

Only the (default) \code{"xspline"} option uses the \verb{knot.*} parameters, while
only the alternative curves use the \code{segments} parameter, and only
\code{"arctangent"} and \code{"sigmoid"} use the \code{curve_range} parameter. (Both are
ignored if not needed.) Larger values of \code{curve_range} result in greater
compression and steeper slopes. The \code{NULL} default will be changed to
\code{2+sqrt(3)} for \code{"arctangent"} and to \code{6} for \code{"sigmoid"}.

These package-specific options set global values for \code{curve_type},
\code{curve_range}, and \code{segments} that will be defaulted to when not manually
set:
\itemize{
\item \code{ggalluvial.curve_type}: defaults to \code{"xspline"}.
\item \code{ggalluvial.curve_range}: defaults to \code{NA}, which triggers the
curve-specific default values.
\item \code{ggalluvial.segments}: defaults to \code{48L}.
}

See \code{\link[base:options]{base::options()}} for how to use options.
}

\section{Defunct parameters}{

The previously defunct parameters \code{axis_width} and \code{ribbon_bend} have been
discontinued. Use \code{width} and \code{knot.pos} instead.
}

\examples{
# use of strata and labels
ggplot(as.data.frame(Titanic),
       aes(y = Freq,
           axis1 = Class, axis2 = Sex, axis3 = Age)) +
  geom_flow() +
  scale_x_discrete(limits = c("Class", "Sex", "Age")) +
  geom_stratum() +
  geom_text(stat = "stratum", aes(label = after_stat(stratum))) +
  ggtitle("Alluvial plot of Titanic passenger demographic data")

# use of facets, with quintic flows
ggplot(as.data.frame(Titanic),
       aes(y = Freq,
           axis1 = Class, axis2 = Sex)) +
  geom_flow(aes(fill = Age), width = .4, curve_type = "quintic") +
  geom_stratum(width = .4) +
  geom_text(stat = "stratum", aes(label = after_stat(stratum)), size = 3) +
  scale_x_discrete(limits = c("Class", "Sex")) +
  facet_wrap(~ Survived, scales = "fixed")

# time series alluvia of WorldPhones data
wph <- as.data.frame(as.table(WorldPhones))
names(wph) <- c("Year", "Region", "Telephones")
ggplot(wph,
       aes(x = Year, alluvium = Region, y = Telephones)) +
  geom_flow(aes(fill = Region, colour = Region),
            width = 0, outline.type = "full")
# treat 'Year' as a number rather than as a factor
wph$Year <- as.integer(as.character(wph$Year))
ggplot(wph,
       aes(x = Year, alluvium = Region, y = Telephones)) +
  geom_flow(aes(fill = Region, colour = Region),
            width = 0, outline.type = "upper")
# hold the knot positions fixed
ggplot(wph,
       aes(x = Year, alluvium = Region, y = Telephones)) +
  geom_flow(aes(fill = Region, colour = Region),
            width = 0, outline.type = "lower", knot.prop = FALSE)

\donttest{
# rightward flow aesthetics for vaccine survey data, with cubic flows
data(vaccinations)
vaccinations$response <- factor(vaccinations$response,
                                rev(levels(vaccinations$response)))
# annotate with proportional counts
ggplot(vaccinations,
       aes(x = survey, stratum = response, alluvium = subject,
           y = freq, fill = response)) +
  geom_lode() + geom_flow(curve_type = "cubic") +
  geom_stratum(alpha = 0) +
  geom_text(stat = "stratum", aes(label = round(after_stat(prop), 3)))
# annotate fixed-width ribbons with counts
ggplot(vaccinations,
       aes(x = survey, stratum = response, alluvium = subject,
           weight = freq, fill = response)) +
  geom_lode() + geom_flow(curve_type = "cubic") +
  geom_stratum(alpha = 0) +
  geom_text(stat = "flow",
            aes(label = after_stat(n),
                hjust = (after_stat(flow) == "to")))
}
}
\seealso{
\code{\link[ggplot2:layer]{ggplot2::layer()}} for additional arguments and
\code{\link[=stat_alluvium]{stat_alluvium()}} and
\code{\link[=stat_flow]{stat_flow()}} for the corresponding stats.

Other alluvial geom layers: 
\code{\link{geom_alluvium}()},
\code{\link{geom_lode}()},
\code{\link{geom_stratum}()}
}
\concept{alluvial geom layers}
