% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-density-2d-sample.R,
%   R/stat-density-2d-sample.R
\docType{data}
\name{geom_density_2d_sample}
\alias{geom_density_2d_sample}
\alias{geom_density2d_sample}
\alias{geom_density_2d_filled_sample}
\alias{geom_density2d_filled_sample}
\alias{StatDensity2dSample}
\alias{StatDensity2dFilledSample}
\alias{stat_density_2d_sample}
\alias{stat_density_2d_filled_sample}
\title{Uncertain contours of a 2D density estimate}
\usage{
geom_density_2d_sample(
  mapping = NULL,
  data = NULL,
  stat = "density_2d_sample",
  position = "identity",
  ...,
  times = 10,
  seed = NULL,
  arrow = NULL,
  arrow.fill = NULL,
  lineend = "butt",
  linejoin = "round",
  linemitre = 10,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)

geom_density_2d_filled_sample(
  mapping = NULL,
  data = NULL,
  stat = "density_2d_filled_sample",
  position = "identity",
  ...,
  times = 10,
  seed = NULL,
  rule = "evenodd",
  lineend = "butt",
  linejoin = "round",
  linemitre = 10,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)

stat_density_2d_sample(
  mapping = NULL,
  data = NULL,
  geom = "density_2d",
  position = "identity",
  ...,
  contour = TRUE,
  contour_var = "density",
  times = 10,
  seed = NULL,
  h = NULL,
  adjust = c(1, 1),
  n = 100,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)

stat_density_2d_filled_sample(
  mapping = NULL,
  data = NULL,
  geom = "density_2d_filled",
  position = "identity",
  ...,
  contour = TRUE,
  contour_var = "density",
  times = 10,
  seed = NULL,
  h = NULL,
  adjust = c(1, 1),
  n = 100,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{position}{A position adjustment to use on the data for this layer. This
can be used in various ways, including to prevent overplotting and
improving the display. The \code{position} argument accepts the following:
\itemize{
\item The result of calling a position function, such as \code{position_jitter()}.
This method allows for passing extra arguments to the position.
\item A string naming the position adjustment. To give the position as a
string, strip the function name of the \code{position_} prefix. For example,
to use \code{position_jitter()}, give the position as \code{"jitter"}.
\item For more information and other ways to specify the position, see the
\link[ggplot2:layer_positions]{layer position} documentation.
}}

\item{...}{
  Arguments passed on to \code{\link[ggplot2:geom_contour]{geom_contour}}
  \describe{
    \item{\code{binwidth}}{The width of the contour bins. Overridden by \code{bins}.}
    \item{\code{bins}}{Number of contour bins. Overridden by \code{breaks}.}
    \item{\code{breaks}}{One of:
\itemize{
\item Numeric vector to set the contour breaks
\item A function that takes the range of the data and binwidth as input
and returns breaks as output. A function can be created from a formula
(e.g. ~ fullseq(.x, .y)).
}

Overrides \code{binwidth} and \code{bins}. By default, this is a vector of length
ten with \code{\link[=pretty]{pretty()}} breaks.}
  }}

\item{times}{A parameter used to control the number of values sampled from 
each distribution.}

\item{seed}{Set the seed for the layers random draw, allows you to plot the
same draw across multiple layers.}

\item{arrow}{specification for arrow heads, as created by \code{\link[grid:arrow]{grid::arrow()}}.}

\item{arrow.fill}{fill colour to use for the arrow head (if closed). \code{NULL}
means use \code{colour} aesthetic.}

\item{lineend}{Line end style (round, butt, square).}

\item{linejoin}{Line join style (round, mitre, bevel).}

\item{linemitre}{Line mitre limit (number greater than 1).}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display. To include legend keys for all levels, even
when no data exists, use \code{TRUE}.  If \code{NA}, all levels are shown in legend,
but unobserved levels are omitted.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:annotation_borders]{annotation_borders()}}.}

\item{rule}{Either \code{"evenodd"} or \code{"winding"}. If polygons with holes are
being drawn (using the \code{subgroup} aesthetic) this argument defines how the
hole coordinates are interpreted. See the examples in \code{\link[grid:grid.path]{grid::pathGrob()}} for
an explanation.}

\item{geom, stat}{Use to override the default connection between
\code{geom_density_2d()} and \code{stat_density_2d()}. For more information at
overriding these connections, see how the \link[ggplot2:layer_stats]{stat} and
\link[ggplot2:layer_geoms]{geom} arguments work.}

\item{contour}{If \code{TRUE}, contour the results of the 2d density
estimation.}

\item{contour_var}{Character string identifying the variable to contour
by. Can be one of \code{"density"}, \code{"ndensity"}, or \code{"count"}. See the section
on computed variables for details.}

\item{h}{Bandwidth (vector of length two). If \code{NULL}, estimated
using \code{\link[MASS:bandwidth.nrd]{MASS::bandwidth.nrd()}}.}

\item{adjust}{A multiplicative bandwidth adjustment to be used if 'h' is
'NULL'. This makes it possible to adjust the bandwidth while still
using the a bandwidth estimator. For example, \code{adjust = 1/2} means
use half of the default bandwidth.}

\item{n}{Number of grid points in each direction.}
}
\value{
A ggplot2 layer
}
\description{
Identical to geom_density_2d() and geom_density_2d_filled, except that it 
will accept a distribution in place of any of the usual aesthetics.
}
\examples{
library(ggplot2)
# ggplot
m <- ggplot(faithful, aes(x = eruptions, y = waiting)) +
  geom_point() +
  xlim(0.5, 6) +
  ylim(40, 110)
# contour lines
m + geom_density_2d()

# ggdibbler
n <- ggplot(uncertain_faithful, aes(x = eruptions, y = waiting)) +
  geom_point_sample(size=2/10) +
  scale_x_continuous_distribution(limits = c(0.5, 6)) +
  scale_y_continuous_distribution(limits = c(40, 110))
n + geom_density_2d_sample(linewidth=2/10, alpha=0.5)

# contour bands
# ggplot
m + geom_density_2d_filled(alpha = 0.5)
# ggdibbler
n + geom_density_2d_filled_sample(alpha = 0.1)

}
\keyword{datasets}
