% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-raster-sample.R, R/geom-rect-sample.R,
%   R/geom-tile-sample.R
\name{geom_raster_sample}
\alias{geom_raster_sample}
\alias{geom_rect_sample}
\alias{geom_tile_sample}
\title{Plot rectangles with uncertainty}
\usage{
geom_raster_sample(
  mapping = NULL,
  data = NULL,
  stat = "identity_sample",
  position = "identity_dodge",
  ...,
  times = 10,
  seed = NULL,
  interpolate = FALSE,
  hjust = 0.5,
  vjust = 0.5,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)

geom_rect_sample(
  mapping = NULL,
  data = NULL,
  stat = "identity_sample",
  position = "identity",
  ...,
  times = 10,
  seed = NULL,
  lineend = "butt",
  linejoin = "mitre",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)

geom_tile_sample(
  mapping = NULL,
  data = NULL,
  stat = "identity_sample",
  position = "identity_dodge",
  ...,
  times = 10,
  seed = NULL,
  lineend = "butt",
  linejoin = "mitre",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{stat}{The statistical transformation to use on the data for this layer.
When using a \verb{geom_*()} function to construct a layer, the \code{stat}
argument can be used to override the default coupling between geoms and
stats. The \code{stat} argument accepts the following:
\itemize{
\item A \code{Stat} ggproto subclass, for example \code{StatCount}.
\item A string naming the stat. To give the stat as a string, strip the
function name of the \code{stat_} prefix. For example, to use \code{stat_count()},
give the stat as \code{"count"}.
\item For more information and other ways to specify the stat, see the
\link[ggplot2:layer_stats]{layer stat} documentation.
}}

\item{position}{A position adjustment to use on the data for this layer. This
can be used in various ways, including to prevent overplotting and
improving the display. The \code{position} argument accepts the following:
\itemize{
\item The result of calling a position function, such as \code{position_jitter()}.
This method allows for passing extra arguments to the position.
\item A string naming the position adjustment. To give the position as a
string, strip the function name of the \code{position_} prefix. For example,
to use \code{position_jitter()}, give the position as \code{"jitter"}.
\item For more information and other ways to specify the position, see the
\link[ggplot2:layer_positions]{layer position} documentation.
}}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}'s \code{params} argument. These
arguments broadly fall into one of 4 categories below. Notably, further
arguments to the \code{position} argument, or aesthetics that are required
can \emph{not} be passed through \code{...}. Unknown arguments that are not part
of the 4 categories below are ignored.
\itemize{
\item Static aesthetics that are not mapped to a scale, but are at a fixed
value and apply to the layer as a whole. For example, \code{colour = "red"}
or \code{linewidth = 3}. The geom's documentation has an \strong{Aesthetics}
section that lists the available options. The 'required' aesthetics
cannot be passed on to the \code{params}. Please note that while passing
unmapped aesthetics as vectors is technically possible, the order and
required length is not guaranteed to be parallel to the input data.
\item When constructing a layer using
a \verb{stat_*()} function, the \code{...} argument can be used to pass on
parameters to the \code{geom} part of the layer. An example of this is
\code{stat_density(geom = "area", outline.type = "both")}. The geom's
documentation lists which parameters it can accept.
\item Inversely, when constructing a layer using a
\verb{geom_*()} function, the \code{...} argument can be used to pass on parameters
to the \code{stat} part of the layer. An example of this is
\code{geom_area(stat = "density", adjust = 0.5)}. The stat's documentation
lists which parameters it can accept.
\item The \code{key_glyph} argument of \code{\link[ggplot2:layer]{layer()}} may also be passed on through
\code{...}. This can be one of the functions described as
\link[ggplot2:draw_key]{key glyphs}, to change the display of the layer in the legend.
}}

\item{times}{A parameter used to control the number of values sampled from 
each distribution.}

\item{seed}{Set the seed for the layers random draw, allows you to plot the
same draw across multiple layers.}

\item{interpolate}{If \code{TRUE} interpolate linearly, if \code{FALSE}
(the default) don't interpolate.}

\item{hjust, vjust}{horizontal and vertical justification of the grob.  Each
justification value should be a number between 0 and 1.  Defaults to 0.5
for both, centering each pixel over its data location.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display. To include legend keys for all levels, even
when no data exists, use \code{TRUE}.  If \code{NA}, all levels are shown in legend,
but unobserved levels are omitted.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:annotation_borders]{annotation_borders()}}.}

\item{lineend}{Line end style (round, butt, square).}

\item{linejoin}{Line join style (round, mitre, bevel).}
}
\value{
A ggplot2 layer
}
\description{
Identical to geom_tile and geom_rect, except that they will accept a 
distribution in place of any of the usual aesthetics.
}
\examples{
library(ggplot2)
library(distributional)
library(dplyr)

# Rasters
#ggplot
ggplot(faithfuld, aes(waiting, eruptions)) + 
  geom_raster(aes(fill = density)) 
#ggdibbler
ggplot(uncertain_faithfuld, aes(waiting, eruptions)) + 
  geom_raster_sample(aes(fill = density)) 

# Justification controls where the cells are anchored
df <- expand.grid(x = 0:5, y = 0:5)
set.seed(1)
df$z <- runif(nrow(df))
uncertain_df <- df |> 
  group_by(x,y) |>
  mutate(z = dist_normal(z, runif(1, 0, 0.1))) |>
  ungroup()

# default is compatible with geom_tile()
# ggplot
ggplot(df, aes(x, y, fill = z)) +
  geom_raster()
#ggdibbler
ggplot(uncertain_df, aes(x, y, fill = z)) +
  geom_raster_sample()

# If you want to draw arbitrary rectangles, 
# use geom_tile_sample() or geom_rect_sample()
tile_df <- data.frame(
  x = rep(c(2, 5, 7, 9, 12), 2),
  y = rep(c(1, 2), each = 5),
  z = factor(rep(1:5, each = 2)),
  w = rep(diff(c(0, 4, 6, 8, 10, 14)), 2)
)
# most likely case that only colour is random
uncertain_tile_df <- tile_df
uncertain_tile_df$z <- dist_transformed((1 + dist_binomial(rep(1:5, 
  each = 2), 0.5)), factor, as.numeric)

# ggplot
ggplot(tile_df, aes(x, y)) +
  geom_tile(aes(fill = z), colour = "grey50")
# ggdibbler
ggplot(uncertain_tile_df, aes(x, y)) +
  geom_tile_sample(aes(fill = z), position="identity_dodge") +
  geom_tile(fill = NA, colour = "grey50", linewidth=1) +
  labs(fill = "z")

# Rectangles
rect_df  <- tile_df |>
  mutate(xmin = x - w / 2,
         xmax = x + w / 2,
         ymin = y,
         ymax = y + 1)
         
uncertain_rect  <- rect_df|>
  mutate(xmin = dist_normal(xmin, 0.5),
         xmax = dist_normal(xmax, 0.5),
         ymin = dist_normal(ymin, 0.5),
         ymax = dist_normal(ymax, 0.5))
         
# ggplot
ggplot(data = rect_df, 
       aes(xmin= xmin, xmax = xmax, ymin = ymin, ymax = ymax)) +
  geom_rect(aes(fill = z), colour = "grey50")
# ggdibbler
ggplot(data = uncertain_rect, 
       aes(xmin= xmin, xmax = xmax, ymin = ymin, ymax = ymax, f = z)) +
  geom_rect_sample(aes(fill = as.factor(after_stat(f))), 
    colour = "grey50", alpha=0.2) +
  labs(fill = "z")
}
