% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/position-stack-nested.R
\docType{data}
\name{position_stack_nested}
\alias{position_stack_nested}
\alias{position_stack_identity}
\alias{PositionStackIdentity}
\alias{position_identity_stack}
\alias{PositionIdentityStack}
\alias{position_stack_dodge}
\alias{PositionStackDodge}
\title{Nested stack positions}
\usage{
position_stack_identity(vjust = 1, reverse = FALSE)

position_stack_dodge(
  vjust = 1,
  reverse = FALSE,
  width = NULL,
  preserve = "single",
  orientation = "x"
)
}
\arguments{
\item{vjust}{Vertical adjustment for geoms that have a position
(like points or lines), not a dimension (like bars or areas). Set to
\code{0} to align with the bottom, \code{0.5} for the middle,
and \code{1} (the default) for the top.}

\item{reverse}{If \code{TRUE}, will reverse the default stacking order.
This is useful if you're rotating both the plot and legend.}

\item{width}{Dodging width, when different to the width of the individual
elements. This is useful when you want to align narrow geoms with wider
geoms. See the examples.}

\item{preserve}{Should dodging preserve the \code{"total"} width of all elements
at a position, or the width of a \code{"single"} element?}

\item{orientation}{Fallback orientation when the layer or the data does not
indicate an explicit orientation, like \code{geom_point()}. Can be \code{"x"}
(default) or \code{"y"}.}
}
\value{
A ggplot2 position
}
\description{
These functions use nested positioning for distributional data, where one of 
the positions is stacked. This allows you to set different position 
adjustments for the "main" and "distribution" parts of your plot.
}
\examples{
# Standard ggplots often have a position adjustment to fix overplotting
# plot with overplotting
library(ggplot2)
ggplot(mpg, aes(class)) + 
  geom_bar(aes(fill = drv),
           position = "stack")

# normal stack warps the scale and doesn't communicate useful info
ggplot(uncertain_mpg, aes(class)) + 
  geom_bar_sample(aes(fill = drv), position = "stack")

# stack_identity
ggplot(uncertain_mpg, aes(class)) + 
  geom_bar_sample(aes(fill = drv), position = "stack_identity", alpha=0.2)
  
# stack_dodge
ggplot(uncertain_mpg, aes(class)) + 
  geom_bar_sample(aes(fill = drv), position = "stack_dodge")
}
\keyword{datasets}
