% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/legend_multi.R
\name{legend_order_guides}
\alias{legend_order_guides}
\title{Control Legend Display Order}
\usage{
legend_order_guides(...)
}
\arguments{
\item{...}{Named arguments where names are aesthetic names and values are
integer order positions. E.g., \code{colour = 1, size = 2}.}
}
\value{
A guides specification that can be added to a plot.
}
\description{
Set the display order of multiple legends. Legends with lower order values
appear first (top or left).
}
\details{
The order value determines the position of the legend relative to others.
Lower values appear first. By default, all legends have order = 0 and appear
in an unspecified order.
}
\examples{
library(ggplot2)

# Plot with multiple legends
p <- ggplot(mtcars, aes(mpg, wt, color = factor(cyl), size = hp)) +
  geom_point()

# Default order
p

# Size legend first, then colour
p + legend_order_guides(size = 1, colour = 2)

# Colour legend first
p + legend_order_guides(colour = 1, size = 2)

}
\seealso{
\code{\link{legend_merge}}, \code{\link{legend_split}}
}
