% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn_functional.R
\name{ggml_layer_add}
\alias{ggml_layer_add}
\title{Element-wise Addition of Two Tensor Nodes}
\usage{
ggml_layer_add(tensors, name = NULL)
}
\arguments{
\item{tensors}{A list of \code{ggml_tensor_node} objects (length >= 2).}

\item{name}{Optional character name for the layer.}
}
\value{
A new \code{ggml_tensor_node} representing the sum.
}
\description{
Adds two (or more) tensor nodes element-wise.  All tensors must have the
same shape.  This is the functional equivalent of a residual / skip
connection.
}
\examples{
\donttest{
x    <- ggml_input(shape = 64L)
a    <- x |> ggml_layer_dense(64, activation = "relu")
b    <- x |> ggml_layer_dense(64)
out  <- ggml_layer_add(list(a, b))
}
}
