% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn_functional.R
\name{ggml_layer_concatenate}
\alias{ggml_layer_concatenate}
\title{Concatenate Tensor Nodes Along an Axis}
\usage{
ggml_layer_concatenate(tensors, axis = 0L, name = NULL)
}
\arguments{
\item{tensors}{A list of \code{ggml_tensor_node} objects (length >= 2).}

\item{axis}{Integer axis along which to concatenate (0-based, ggml convention).
Default \code{0L} concatenates along the first dimension (features for
flat tensors).}

\item{name}{Optional character name for the layer.}
}
\value{
A new \code{ggml_tensor_node} representing the concatenated tensor.
}
\description{
Concatenates two or more tensor nodes along the specified axis.
}
\examples{
\donttest{
x   <- ggml_input(shape = 32L)
y   <- ggml_input(shape = 32L)
out <- ggml_layer_concatenate(list(x, y), axis = 0L)
}
}
