% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn_functional.R, R/nn_layers.R
\name{ggml_layer_conv_1d}
\alias{ggml_layer_conv_1d}
\title{Create a Conv1D Layer Object}
\usage{
ggml_layer_conv_1d(
  model,
  filters,
  kernel_size,
  activation = NULL,
  input_shape = NULL,
  strides = 1L,
  padding = "valid",
  name = NULL,
  trainable = TRUE
)

ggml_layer_conv_1d(
  model,
  filters,
  kernel_size,
  activation = NULL,
  input_shape = NULL,
  strides = 1L,
  padding = "valid",
  name = NULL,
  trainable = TRUE
)
}
\arguments{
\item{model}{A ggml_sequential_model object}

\item{filters}{Number of output filters}

\item{kernel_size}{Integer kernel size}

\item{activation}{Activation function name: "relu", "sigmoid", "tanh", "softmax", or NULL}

\item{input_shape}{Input shape c(L, C) - required for first layer only (length, channels)}

\item{strides}{Integer stride (default 1)}

\item{padding}{"valid" (no padding) or "same" (preserve length)}

\item{name}{Optional character name for the layer.}

\item{trainable}{Logical; whether the layer weights are updated during training.}
}
\value{
A \code{ggml_layer} object.

The model object with the conv_1d layer appended (invisibly).
}
\description{
Create a Conv1D Layer Object

Add 1D Convolution Layer
}
\examples{
\donttest{
model <- ggml_model_sequential() |>
  ggml_layer_conv_1d(32, 3, activation = "relu",
                     input_shape = c(100, 1))
}
}
