% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn_layers.R
\name{ggml_layer_gru}
\alias{ggml_layer_gru}
\title{Add a GRU Layer}
\usage{
ggml_layer_gru(
  model,
  units,
  return_sequences = FALSE,
  activation = "tanh",
  recurrent_activation = "sigmoid",
  input_shape = NULL,
  name = NULL,
  trainable = TRUE
)
}
\arguments{
\item{model}{A \code{ggml_sequential_model} or \code{ggml_tensor_node}.}

\item{units}{Integer, number of hidden units.}

\item{return_sequences}{Logical; return all hidden states or only the last.}

\item{activation}{Activation for the candidate hidden state (\code{"tanh"}).}

\item{recurrent_activation}{Activation for z/r gates (\code{"sigmoid"}).}

\item{input_shape}{Input shape \code{c(seq_len, input_size)} -- required for the first layer only.}

\item{name}{Optional layer name.}

\item{trainable}{Logical.}
}
\value{
Updated model or a new \code{ggml_tensor_node}.
}
\description{
Gated Recurrent Unit recurrent layer.  Implemented as an unrolled
computation graph (BPTT).
}
\section{Weight layout}{

\itemize{
  \item \code{W_zh} \code{[input_size, 2*units]} — input kernel for z and r
    gates.
  \item \code{U_zh} \code{[units, 2*units]} — recurrent kernel for z and r.
  \item \code{b_zh} \code{[2*units]} — bias for z and r.
  \item \code{W_n}  \code{[input_size, units]} — input kernel for candidate.
  \item \code{U_n}  \code{[units, units]} — recurrent kernel for candidate.
  \item \code{b_n}  \code{[units]} — bias for candidate.
}
}

\examples{
\donttest{
model <- ggml_model_sequential() |>
  ggml_layer_gru(64L, input_shape = c(10L, 32L)) |>
  ggml_layer_dense(10L, activation = "softmax")
}
}
