% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tensors.R
\name{ggml_new_i32}
\alias{ggml_new_i32}
\title{Create Scalar I32 Tensor}
\usage{
ggml_new_i32(ctx, value)
}
\arguments{
\item{ctx}{GGML context}

\item{value}{Integer value}
}
\value{
Tensor pointer (1-element I32 tensor)
}
\description{
Creates a 1-element tensor containing a single integer value.
Useful for indices, counters, and other scalar integer operations.
}
\examples{
\donttest{
ctx <- ggml_init(1024 * 1024)
scalar <- ggml_new_i32(ctx, 42)
ggml_get_i32(scalar)
ggml_free(ctx)
}
}
