% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tensors.R
\name{ggml_new_tensor_4d}
\alias{ggml_new_tensor_4d}
\title{Create 4D Tensor}
\usage{
ggml_new_tensor_4d(ctx, type = GGML_TYPE_F32, ne0, ne1, ne2, ne3)
}
\arguments{
\item{ctx}{GGML context}

\item{type}{Data type (default GGML_TYPE_F32)}

\item{ne0}{Size of dimension 0}

\item{ne1}{Size of dimension 1}

\item{ne2}{Size of dimension 2}

\item{ne3}{Size of dimension 3}
}
\value{
Tensor pointer
}
\description{
Create 4D Tensor
}
\examples{
\donttest{
ctx <- ggml_init(1024 * 1024)
t <- ggml_new_tensor_4d(ctx, GGML_TYPE_F32, 8, 8, 3, 2)
ggml_nelements(t)
ggml_free(ctx)
}
}
