% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operations.R
\name{ggml_soft_max_ext_inplace}
\alias{ggml_soft_max_ext_inplace}
\title{Extended Softmax Inplace (Graph)}
\usage{
ggml_soft_max_ext_inplace(ctx, a, mask = NULL, scale = 1, max_bias = 0)
}
\arguments{
\item{ctx}{GGML context}

\item{a}{Input tensor (typically attention scores)}

\item{mask}{Optional attention mask tensor (F16 or F32). NULL for no mask.
Shape must be broadcastable to input tensor.}

\item{scale}{Scaling factor, typically 1/sqrt(head_dim)}

\item{max_bias}{Maximum ALiBi bias (0.0 to disable ALiBi)}
}
\value{
View of input tensor with softmax applied in place
}
\description{
Creates a graph node for extended softmax, modifying input tensor in place.
Returns a view of the input tensor.
}
\seealso{
Other softmax: 
\code{\link{ggml_soft_max_ext_back_inplace}()}
}
\concept{softmax}
