% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operations.R
\name{ggml_tanh}
\alias{ggml_tanh}
\title{Tanh Activation (Graph)}
\usage{
ggml_tanh(ctx, a)
}
\arguments{
\item{ctx}{GGML context}

\item{a}{Input tensor}
}
\value{
Tensor representing the tanh operation
}
\description{
Creates a graph node for hyperbolic tangent activation.
}
\examples{
\donttest{
ctx <- ggml_init(1024 * 1024)
a <- ggml_new_tensor_1d(ctx, GGML_TYPE_F32, 5)
ggml_set_f32(a, c(-2, -1, 0, 1, 2))
result <- ggml_tanh(ctx, a)
graph <- ggml_build_forward_expand(ctx, result)
ggml_graph_compute(ctx, graph)
ggml_get_f32(result)
ggml_free(ctx)
}
}
