% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pathway_gsea.R
\name{run_limma_gsea}
\alias{run_limma_gsea}
\title{Run limma-based gene set analysis (camera/fry)}
\usage{
run_limma_gsea(
  abundance_mat,
  metadata,
  group,
  covariates = NULL,
  contrast = NULL,
  gene_sets,
  method = "camera",
  inter.gene.cor = 0.01,
  min_size = 5,
  max_size = 500,
  p.adjust.method = "BH"
)
}
\arguments{
\item{abundance_mat}{A matrix of abundance data with features as rows and samples as columns}

\item{metadata}{A data frame containing sample metadata}

\item{group}{A character string specifying the grouping variable column name}

\item{covariates}{A character vector of covariate column names (optional)}

\item{contrast}{Contrast specification for multi-group comparisons (optional)}

\item{gene_sets}{A named list of gene sets (pathway -> gene IDs)}

\item{method}{Either "camera" or "fry"}

\item{inter.gene.cor}{Inter-gene correlation for camera (default 0.01)}

\item{min_size}{Minimum gene set size}

\item{max_size}{Maximum gene set size}

\item{p.adjust.method}{P-value adjustment method}
}
\value{
A data frame containing gene set analysis results
}
\description{
This internal function implements limma's camera and fry methods for gene set
enrichment analysis with support for covariates.
}
\keyword{internal}
