% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discrete-cosmic.R
\name{scale_color_cosmic}
\alias{scale_color_cosmic}
\alias{scale_colour_cosmic}
\alias{scale_fill_cosmic}
\title{COSMIC color scales}
\usage{
scale_color_cosmic(
  palette = c("hallmarks_light", "hallmarks_dark", "signature_substitutions"),
  alpha = 1,
  ...
)

scale_colour_cosmic(
  palette = c("hallmarks_light", "hallmarks_dark", "signature_substitutions"),
  alpha = 1,
  ...
)

scale_fill_cosmic(
  palette = c("hallmarks_light", "hallmarks_dark", "signature_substitutions"),
  alpha = 1,
  ...
)
}
\arguments{
\item{palette}{Palette type. Currently there are three available options:
\itemize{
\item \code{"signature_substitutions"} (6-color palette).
\item \code{"hallmarks_light"} (10-color palette).
\item \code{"hallmarks_dark"} (10-color palette).
}

The \code{"hallmarks_light"} option is from
\href{https://pubmed.ncbi.nlm.nih.gov/21376230/}{Hanahan and Weinberg (2011)}.}

\item{alpha}{Transparency level, a real number in (0, 1].
See \code{alpha} in \code{\link[grDevices:rgb]{grDevices::rgb()}} for details.}

\item{...}{Additional parameters for \code{\link[ggplot2:discrete_scale]{ggplot2::discrete_scale()}}.}
}
\description{
See \code{\link[=pal_cosmic]{pal_cosmic()}} for details.
}
\examples{
example_scatterplot() + scale_color_cosmic()
example_barplot() + scale_fill_cosmic()
}
\author{
Joshua H. Cook | \email{joshuacook0023@gmail.com} |
\href{https://github.com/jhrcook}{@jhrcook}
}
