% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fortify.dbrda.R
\name{fortify.dbrda}
\alias{fortify.dbrda}
\alias{tidy.dbrda}
\title{Fortify a \code{"dbrda"} object.}
\usage{
\method{fortify}{dbrda}(
  model,
  data = NULL,
  axes = 1:6,
  layers = c("wa", "lc", "bp", "reg", "cn"),
  const = NULL,
  ...
)

\method{tidy}{dbrda}(
  x,
  data = NULL,
  axes = 1:6,
  layers = c("wa", "lc", "bp", "reg", "cn"),
  const = NULL,
  ...
)
}
\arguments{
\item{model, x}{an object of class \code{"dbrda"}, the result of a call to
\code{\link[vegan:dbrda]{vegan::dbrda()}}.}

\item{data}{currently ignored.}

\item{axes}{numeric; which axes to extract scores for.}

\item{layers}{character; the scores to extract in the fortified object.
Passed to \code{display} in the respective \code{\link[vegan:scores]{vegan::scores()}} method.}

\item{const}{NULL; General scaling constant to RDA scores. See
\code{\link[vegan:plot.cca]{vegan::scores.rda()}} for the details.}

\item{...}{additional arguments passed to \code{\link[vegan:plot.cca]{vegan::scores.rda()}}.}
}
\value{
A data frame (tibble) in long format containing the ordination
scores. The first two components are \code{score} (the type of score in each
row) and \code{label} (the text label to use on plots for this row). The
remaining columns are the extracted ordination axis scores.
}
\description{
Fortifies an object of class \code{"dbrda"} to produce a
data frame of the selected axis scores in long format, suitable for
plotting with \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}.
}
\details{
TODO
}
\examples{

library("vegan")

data(dune)
data(dune.env)

sol <- dbrda(dune ~ A1 + Management, data = dune.env)
head(fortify(sol))
}
\author{
Gavin L. Simpson
}
