% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detect_twilights.R
\name{detect_twilights}
\alias{detect_twilights}
\title{Detect Twilight Times from Light Data}
\usage{
detect_twilights(light_data, threshold = 2)
}
\arguments{
\item{light_data}{A data.frame with columns \code{Date} (POSIXct) and
\code{Light} (numeric)}

\item{threshold}{Numeric light threshold in lux for day/night distinction
(default: 2)}
}
\value{
A data.frame with columns:
  \item{Twilight}{POSIXct datetime of twilight event}
  \item{Rise}{Logical, TRUE for sunrise, FALSE for sunset}
}
\description{
Detects sunrise and sunset times from light intensity data using a
threshold-crossing method. This is a proven, simple approach that
identifies transitions between day and night.
}
\examples{
# Detect twilights from example data
example_file <- gls_example("W086")
light_data <- read_lux_file(example_file)
twilights <- detect_twilights(light_data, threshold = 2)
head(twilights)

}
