% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare.R
\name{compare}
\alias{compare}
\alias{compare.default}
\alias{compare.PlackettLuce}
\title{Compare agreement between two methods}
\usage{
compare(x, y, ...)

\method{compare}{default}(x, y, labels = NULL, ...)

\method{compare}{PlackettLuce}(x, y, ...)
}
\arguments{
\item{x}{a numeric vector, or an object
of class \code{PlackettLuce}}

\item{y}{a numeric vector, or an object
of class \code{PlackettLuce}}

\item{...}{additional arguments passed to methods}

\item{labels}{optional, a vector with the same length \var{x}
to plot values}
}
\value{
a ggplot with the agreement
}
\description{
Measures the agreement between two methods
}
\examples{
set.seed(1)
x = runif(10, -1, 2)

set.seed(2)
y = runif(10, -1, 2)

compare(x, y)

}
\references{
Bland, M. J., and Altman, D. G. (1986).
 Lancet (8476):307-10.
}
