% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{gr_plot_vars}
\alias{gr_plot_vars}
\title{Plot interannual hydrograph variable changes}
\usage{
gr_plot_vars(
  df,
  ...,
  tests = NULL,
  exclude = NULL,
  smooth = TRUE,
  layout = as.matrix(1),
  pagebreak = FALSE,
  print = TRUE
)
}
\arguments{
\item{df}{\code{data.frame} of hydrograph and meteorological variables produced by \code{\link[=gr_summarize]{gr_summarize()}}.}

\item{...}{Quoted sequence of variable names.}

\item{tests}{\code{list} of tests for the same variables (generated by \code{\link[=gr_test_vars]{gr_test_vars()}} function). If tests are specified, then they are added to the plot.}

\item{exclude}{Integer vector of years to be excluded from plotting.}

\item{smooth}{Logical. If \code{TRUE} then local smoothing regression is plotted. Defaults to \code{TRUE}.}

\item{layout}{\code{matrix} that encodes the order of plotting.}

\item{pagebreak}{Logical. Whether to break page between plots (\code{\link[=gr_report]{gr_report()}}). Defaults to \code{FALSE}.}

\item{print}{Boolean. Print plot? Defaults to \code{TRUE}. Use \code{FALSE} if you want to tweak the plot aesthetics before plotting.}
}
\value{
\code{list} of \code{ggplot2} objects, one for each variable, representing its interannual changes
}
\description{
This function plots the hydrograph separation variables produced by \code{\link[=gr_summarize]{gr_summarize()}}. Different background fill colors and line types are used to differentiate seasons and variable types.
}
\examples{
library(grwat)

data(spas) # example Spas-Zagorye data is included with grwat package

# separate
sep = gr_separate(spas, params = gr_get_params(reg = 'center'))

# summarize from 1965 to 1990
vars = gr_summarize(sep, 1965, 1990)

# plot one selected variable
gr_plot_vars(vars, Qygr) 

# plot two variables sequentially
gr_plot_vars(vars, D10w1, Wsprngr)

# four variables in matrix layout with tests calculated on the fly
gr_plot_vars(vars, Qspmax, Qygr, D10w1, Wsprngr,
             layout = matrix(1:4, nrow = 2, byrow = TRUE),
             tests = TRUE) 
}
