% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify_rows.R
\name{row_order}
\alias{row_order}
\title{Modify the order of rows within groups}
\usage{
row_order(data, ..., groups = NULL, reverse = FALSE)
}
\arguments{
\item{data}{\emph{The gt table data object}

\verb{obj:<gt_tbl>} // \strong{required}

This is the \strong{gt} table object that is commonly created through use of the
\code{\link[=gt]{gt()}} function.}

\item{...}{\emph{Column expressions for ordering}

\verb{<column expressions>} // \strong{required}

Column names or expressions describing how to order the rows. Multiple
columns can be specified for hierarchical sorting, where the first column
is the primary sort key.}

\item{groups}{\emph{Specification of row group IDs}

\verb{vector<character>|NULL} // \emph{default:} \code{NULL}

An optional character vector of row group ID values to target. If \code{NULL}
(the default), the ordering is applied to rows in all groups. If specified,
only rows within the indicated groups will be reordered.}

\item{reverse}{\emph{Reverse the sort order}

\verb{scalar<logical>} // \emph{default:} \code{FALSE}

Should the sort order be reversed (i.e., descending)? By default this is
\code{FALSE}, which sorts in ascending order.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
We can modify the display order of rows within any row groups in a \strong{gt}
object with \code{row_order()}. One or more column names can be provided to define
the sorting criteria. By default, rows are sorted in ascending order; use
\code{reverse = TRUE} to sort in descending order. The ordering is applied lazily
during the table build phase, ensuring it works alongside other row-reordering
operations.
}
\section{Examples}{


Let's use the \code{\link{gtcars}} dataset to demonstrate row ordering within groups.
We'll create a \strong{gt} table grouped by country and then order rows within
each group by the car price in descending order.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{gtcars |>
  dplyr::select(mfr, model, ctry_origin, msrp) |>
  dplyr::filter(ctry_origin \%in\% c("Japan", "United Kingdom")) |>
  dplyr::slice_head(n = 12) |>
  gt(groupname_col = "ctry_origin") |>
  row_order(msrp, reverse = TRUE) |>
  fmt_currency(columns = msrp, decimals = 0) |>
  tab_options(column_labels.hidden = TRUE)
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_row_order_1.png" alt="This image of a table was generated from the first code example in the `row_order()` help file." style="width:100\%;">
}}

Using \code{\link{towny}}, we can order rows only within specific groups. Here we
order Ontario municipalities by population density in 2021, but only for
the "city" and "town" groups (leaving "township" rows in their original
order):

\if{html}{\out{<div class="sourceCode r">}}\preformatted{towny |>
  dplyr::filter(csd_type \%in\% c("city", "town", "township")) |>
  dplyr::select(name, csd_type, population_2021, density_2021) |>
  dplyr::slice_head(n = 5, by = csd_type) |>
  gt(groupname_col = "csd_type") |>
  fmt_integer(columns = population_2021) |>
  fmt_number(columns = density_2021, decimals = 1) |>
  row_order(density_2021, groups = c("city", "town"), reverse = TRUE)
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_row_order_2.png" alt="This image of a table was generated from the second code example in the `row_order()` help file." style="width:100\%;">
}}

Using \code{\link{countrypops}}, multiple sorting columns can be specified for
hierarchical ordering. Here we create a table grouped by year, and sort
countries by population within each year:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{countrypops |>
  filter(country_code_2 \%in\% c("BR", "RU", "IN", "CN", "US", "ID")) |>
  filter(year \%in\% c(2000, 2010, 2020)) |>
  select(year, country_name, population) |>
  gt(groupname_col = "year", row_group_as_column = TRUE) |>
  fmt_integer(columns = population) |>
  row_order(population, reverse = TRUE) |>
  opt_vertical_padding(scale = 0.5)
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_row_order_3.png" alt="This image of a table was generated from the third code example in the `row_order()` help file." style="width:100\%;">
}}
}

\section{Function ID}{

6-4
}

\section{Function Introduced}{

\emph{In Development}
}

\seealso{
\code{\link[=row_group_order]{row_group_order()}}, which orders the groups themselves.

Other row addition/modification functions: 
\code{\link{grand_summary_rows}()},
\code{\link{row_group_order}()},
\code{\link{rows_add}()},
\code{\link{summary_columns}()},
\code{\link{summary_rows}()}
}
\concept{row addition/modification functions}
