% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert_gtfs.R
\name{assert_gtfs}
\alias{assert_gtfs}
\title{GTFS object validator}
\usage{
assert_gtfs(x)
}
\arguments{
\item{x}{A GTFS object.}
}
\value{
The same GTFS object passed to \code{x}.
}
\description{
Asserts that a GTFS object is valid. Valid objects are those in which:
\itemize{
\item Every element is named.
\item Every element inherits from \code{data.frame}s.
}

The exception to the second rule are objects that contain an element named
\code{"."}. In such case, this element is actually composed by a named list of
elements who inherit from \code{data.frame}s.
}
\examples{
gtfs_path <- system.file("extdata/ggl_gtfs.zip", package = "gtfsio")

gtfs <- import_gtfs(gtfs_path)
gtfs <- assert_gtfs(gtfs)

}
\seealso{
Other constructors: 
\code{\link{new_gtfs}()}
}
\concept{constructors}
