% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_ci.R
\name{add_ci}
\alias{add_ci}
\alias{add_ci.tbl_summary}
\title{Add CI Column}
\usage{
add_ci(x, ...)

\method{add_ci}{tbl_summary}(
  x,
  method = list(all_continuous() ~ "t.test", all_categorical() ~ "wilson"),
  include = everything(),
  statistic = list(all_continuous() ~ "{conf.low}, {conf.high}", all_categorical() ~
    "{conf.low}\%, {conf.high}\%"),
  conf.level = 0.95,
  style_fun = list(all_continuous() ~ label_style_sigfig(), all_categorical() ~
    label_style_sigfig(scale = 100)),
  pattern = NULL,
  ...
)
}
\arguments{
\item{x}{(\code{tbl_summary})\cr
a summary table of class \code{'tblsummary'}}

\item{...}{These dots are for future extensions and must be empty.}

\item{method}{(\code{\link[=syntax]{formula-list-selector}})\cr
Confidence interval method. Default is
\code{list(all_continuous() ~ "t.test", all_categorical() ~ "wilson")}.
See details below.}

\item{include}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
Variables to include in the summary table. Default is \code{everything()}.}

\item{statistic}{(\code{\link[=syntax]{formula-list-selector}})\cr
Indicates how the confidence interval will be displayed.
Default is \code{list(all_continuous() ~ "{conf.low}, {conf.high}", all_categorical() ~ "{conf.low}\%, {conf.high}\%")}}

\item{conf.level}{(scalar \code{real})\cr
Confidence level. Default is \code{0.95}}

\item{style_fun}{(\code{function})\cr
Function to style upper and lower bound of confidence interval. Default is
\code{list(all_continuous() ~ label_style_sigfig(), all_categorical() ~ label_style_sigfig(scale =  100))}.}

\item{pattern}{(\code{string})\cr
Indicates the pattern to use to merge the CI with
the statistics cell. The default is NULL, where no columns are merged.
The two columns that will be merged are the statistics column,
represented by \code{"{stat}"} and the CI column represented by \code{"{ci}"},
e.g. \code{pattern = "{stat} ({ci})"} will merge the two columns with the CI
in parentheses. Default is \code{NULL}, and no merging is performed.}
}
\value{
gtsummary table
}
\description{
Add a new column with the confidence intervals for proportions, means, etc.
}
\section{method argument}{


Must be one of
\itemize{
\item \code{"wilson"}, \code{"wilson.no.correct"} calculated via \code{prop.test(correct = c(TRUE, FALSE))} for \strong{categorical} variables
\item \code{"exact"} calculated via \code{stats::binom.test()} for \strong{categorical} variables
\item \code{"wald"}, \code{"wald.no.correct"} calculated via \verb{cardx::proportion_ci_wald(correct = c(TRUE, FALSE)} for \strong{categorical} variables
\item \code{"agresti.coull"} calculated via \code{cardx::proportion_ci_agresti_coull()} for \strong{categorical} variables
\item \code{"jeffreys"} calculated via \code{cardx::proportion_ci_jeffreys()} for \strong{categorical} variables
\item \code{"t.test"} calculated via \code{stats::t.test()} for \strong{continuous} variables
\item \code{"wilcox.test"} calculated via \code{stats::wilcox.test()} for \strong{continuous} variables
}
}

\examples{
\dontshow{if ((identical(Sys.getenv("NOT_CRAN"), "true") || identical(Sys.getenv("IN_PKGDOWN"), "true")) && gtsummary:::is_pkg_installed("broom", ref = "cardx")) withAutoprint(\{ # examplesIf}
# Example 1 ----------------------------------
trial |>
  tbl_summary(
    missing = "no",
    statistic = all_continuous() ~ "{mean} ({sd})",
    include = c(marker, response, trt)
  ) |>
  add_ci()

# Example 2 ----------------------------------
trial |>
  select(response, grade) \%>\%
  tbl_summary(
    statistic = all_categorical() ~ "{p}\%",
    missing = "no",
    include = c(response, grade)
  ) |>
  add_ci(pattern = "{stat} ({ci})") |>
  remove_footnote_header(everything())
\dontshow{\}) # examplesIf}
}
